/*
 * Decompiled with CFR 0.152.
 */
package org.mule.serialization.internal;

import com.google.common.primitives.Primitives;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.serialization.SerializationException;
import org.mule.session.DefaultMuleSession;
import org.mule.util.IOUtils;
import org.mule.util.Preconditions;

public class MuleSessionWithNativeTypesSerializer
implements ObjectSerializer {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    private byte[] doSerialize(Object object) throws Exception {
        if (!(object instanceof DefaultMuleSession)) {
            throw new InvalidClassException("Only DefaultMuleSession is supported");
        }
        JSONObject jsonMap = new JSONObject();
        DefaultMuleSession session = (DefaultMuleSession)object;
        for (Map.Entry entry : session.getProperties().entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (this.allowClass(value.getClass())) {
                this.writeObject(jsonMap, (String)entry.getKey(), value);
                continue;
            }
            throw new InvalidClassException("Only primitive types are allowed. Found a '" + value.getClass() + "' for key '" + (String)entry.getKey() + "'");
        }
        return jsonMap.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void writeObject(JSONObject jsonMap, String key, Object value) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)value.getClass().getName());
        if (value instanceof Date) {
            jsonObject.put("value", (Object)dateFormat.format((Date)value));
        } else {
            jsonObject.put("value", value);
        }
        jsonMap.put(key, (Object)jsonObject);
    }

    private Object readObject(JSONObject jsonMap, String key) {
        JSONObject jsonObject = (JSONObject)jsonMap.get(key);
        String typeString = jsonObject.getString("type");
        if (typeString.equals(Date.class.getName())) {
            try {
                return dateFormat.parse(jsonObject.getString("value"));
            }
            catch (ParseException e) {
                throw new SerializationException("Invalid date format processing key '" + key + "': '" + jsonObject.getString("value") + "'");
            }
        }
        return jsonObject.get("value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
        DefaultMuleSession muleSession = new DefaultMuleSession();
        BufferedReader streamReader = null;
        try {
            String inputStr;
            streamReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder responseStrBuilder = new StringBuilder();
            while ((inputStr = streamReader.readLine()) != null) {
                responseStrBuilder.append(inputStr);
            }
            JSONObject jsonObject = this.stringToJson(responseStrBuilder.toString());
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = this.readObject(jsonObject, key);
                if (this.allowClass(value.getClass())) {
                    muleSession.setProperty(key, value);
                    continue;
                }
                throw new InvalidClassException("Only primitive types are allowed. Found a '" + value.getClass() + "' for key '" + key + "'");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(streamReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)streamReader);
        return (T)muleSession;
    }

    private boolean allowClass(Class clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || Primitives.isWrapperType((Class)clazz) || Date.class.equals((Object)clazz);
    }

    private JSONObject stringToJson(String asString) {
        try {
            return new JSONObject(asString);
        }
        catch (JSONException e) {
            throw new SerializationException("Invalid JSON '" + asString + "'", (Throwable)e);
        }
    }

    public byte[] serialize(Object object) throws SerializationException {
        try {
            return this.doSerialize(object);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize object of class '" + object.getClass().getName() + "'", (Throwable)e);
        }
    }

    public void serialize(Object object, OutputStream out) throws SerializationException {
        try {
            byte[] bytes = this.serialize(object);
            out.write(bytes);
            out.flush();
        }
        catch (IOException e) {
            throw new SerializationException("Could not write object of class '" + object.getClass().getName() + "' to output stream", (Throwable)e);
        }
    }

    public <T> T deserialize(byte[] bytes) throws SerializationException {
        return this.deserialize(bytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(byte[] bytes, ClassLoader classLoader) throws SerializationException {
        T t;
        Preconditions.checkArgument((bytes != null ? 1 : 0) != 0, (String)"The byte[] must not be null");
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(bytes);
            t = this.deserialize(inputStream, classLoader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return t;
    }

    public <T> T deserialize(InputStream inputStream) throws SerializationException {
        return this.deserialize(inputStream, null);
    }

    public <T> T deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
        Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, (String)"Cannot deserialize a null stream");
        try {
            return this.doDeserialize(inputStream, classLoader);
        }
        catch (Exception e) {
            throw new SerializationException("Could not deserialize object", (Throwable)e);
        }
    }
}

