/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.serialization.DefaultObjectSerializer;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.serialization.SerializationException;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.serialization.internal.MuleSessionWithNativeTypesSerializer;
import org.mule.util.store.DeserializationPostInitialisable;

public abstract class AbstractSessionHandler
implements SessionHandler {
    public static final String ACTIVATE_NATIVE_SESSION_SERIALIZATION_PROPERTY = "mule.session.serialization.native.enable";
    public static final String ALLOW_HTTP_FALLBACK_MAX_TIMESTAMP_PROPERTY = "mule.session.serialization.http.fallback.maxTimestamp";
    public static final String ALLOW_MSG_FALLBACK_MAX_TIMESTAMP_PROPERTY = "mule.session.serialization.msg.fallback.maxTimestamp";
    protected boolean ACTIVATE_NATIVE_SESSION_SERIALIZATION = Boolean.getBoolean("mule.session.serialization.native.enable");
    protected static final Long ENFORCE_SERIALIZATION_SINCE_TIMESTAMP;
    protected static final Long ALLOW_MSG_FALLBACK_MAX_TIMESTAMP;
    protected static final Long ALLOW_HTTP_FALLBACK_MAX_TIMESTAMP;
    protected static final Set<String> MESSAGING_TRANSPORTS;
    protected static final Set<String> HTTP_TRANSPORTS;
    private static Log logger;
    private ObjectSerializer nativeObjectSerializer = new MuleSessionWithNativeTypesSerializer();
    private ObjectSerializerLocator objectSerializerLocator = new FromMessageObjectSerializerLocator();
    private ObjectSerializer wrappedSerializer = null;

    protected <T> T deserialize(MuleMessage message, byte[] bytes) {
        try {
            return this.deserialize(message, bytes, this.nativeObjectSerializer);
        }
        catch (SerializationException firstError) {
            if (this.isFallbackAllowed(this.getEndpoint(message))) {
                ObjectSerializer secondSerializer = this.objectSerializerLocator.getObjectSerializer(message);
                return this.deserialize(message, bytes, secondSerializer);
            }
            throw firstError;
        }
    }

    protected boolean isFallbackAllowed(String endpoint) {
        for (String messagingTransport : MESSAGING_TRANSPORTS) {
            if (!endpoint.startsWith(messagingTransport + ":")) continue;
            return System.currentTimeMillis() < ALLOW_MSG_FALLBACK_MAX_TIMESTAMP;
        }
        return System.currentTimeMillis() < ALLOW_HTTP_FALLBACK_MAX_TIMESTAMP;
    }

    private boolean isNativeSerializationActivated(String endpoint) {
        return this.ACTIVATE_NATIVE_SESSION_SERIALIZATION && System.currentTimeMillis() > ENFORCE_SERIALIZATION_SINCE_TIMESTAMP;
    }

    private <T> T deserialize(MuleMessage message, byte[] bytes, ObjectSerializer objectSerializer) {
        Object object = this.isNativeSerializationActivated(this.getEndpoint(message)) ? this.nativeObjectSerializer.deserialize(bytes, message.getMuleContext().getExecutionClassLoader()) : this.objectSerializerLocator.getObjectSerializer(message).deserialize(bytes, message.getMuleContext().getExecutionClassLoader());
        if (object instanceof DeserializationPostInitialisable) {
            try {
                DeserializationPostInitialisable.Implementation.init((Object)object, (MuleContext)message.getMuleContext());
            }
            catch (Exception e) {
                throw new SerializationException("Could not initialise session after deserialization", (Throwable)e);
            }
        }
        return (T)object;
    }

    protected byte[] serialize(MuleMessage message, Object object) {
        if (this.isNativeSerializationActivated(this.getEndpoint(message))) {
            return this.nativeObjectSerializer.serialize(object);
        }
        return this.objectSerializerLocator.getObjectSerializer(message).serialize(object);
    }

    protected String getEndpoint(MuleMessage message) {
        return String.valueOf(message.getInboundProperty("MULE_ENDPOINT"));
    }

    @Inject
    @DefaultObjectSerializer
    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializerLocator = new FixedObjectSerializerLocator(objectSerializer);
    }

    static {
        logger = LogFactory.getLog(AbstractSessionHandler.class);
        HashSet<String> messagingTransports = new HashSet<String>();
        messagingTransports.add("vm");
        messagingTransports.add("jms");
        messagingTransports.add("wmq");
        messagingTransports.add("amqp");
        messagingTransports.add("amqps");
        messagingTransports.add("imap");
        messagingTransports.add("imaps");
        messagingTransports.add("pop3");
        messagingTransports.add("pop3s");
        messagingTransports.add("msmq");
        MESSAGING_TRANSPORTS = Collections.unmodifiableSet(messagingTransports);
        HashSet<String> httpTransports = new HashSet<String>();
        httpTransports.add("http");
        httpTransports.add("https");
        httpTransports.add("jetty");
        httpTransports.add("jetty-ssl");
        httpTransports.add("axis");
        httpTransports.add("servlet");
        HTTP_TRANSPORTS = Collections.unmodifiableSet(httpTransports);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        logger.info((Object)"SE-13712 applied. ");
        String sinceTimestamp = System.getProperty("mule.session.serialization.enforce.sinceTimestamp", System.getProperty("mule.session.sign.serializer.sinceTimestamp"));
        try {
            if (sinceTimestamp == null) {
                logger.info((Object)"    enforce.sinceTimestamp: Always");
                ENFORCE_SERIALIZATION_SINCE_TIMESTAMP = 0L;
            } else {
                logger.info((Object)("    enforce.sinceTimestamp: " + sinceTimestamp));
                ENFORCE_SERIALIZATION_SINCE_TIMESTAMP = dateFormat.parse(sinceTimestamp).getTime();
            }
        }
        catch (ParseException e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("Could not parse 'mule.session.sign.serializer.sinceTimestamp' with value '" + sinceTimestamp + "'. Expected format is 'yyyy-MM-dd'T'HH:mm:ss.SSSZ'")), (Throwable)e);
        }
        String msgMaxTimestamp = System.getProperty(ALLOW_MSG_FALLBACK_MAX_TIMESTAMP_PROPERTY, System.getProperty("mule.session.sign.msg.fallback.maxTimestamp"));
        try {
            if (msgMaxTimestamp == null) {
                logger.info((Object)"    msg.fallback.maxTimestamp: Disabled");
                ALLOW_MSG_FALLBACK_MAX_TIMESTAMP = 0L;
            } else {
                logger.info((Object)("    msg.fallback.maxTimestamp: " + msgMaxTimestamp));
                ALLOW_MSG_FALLBACK_MAX_TIMESTAMP = dateFormat.parse(msgMaxTimestamp).getTime();
            }
        }
        catch (ParseException e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("Could not parse 'mule.session.serialization.msg.fallback.maxTimestamp' with value '" + msgMaxTimestamp + "'. Expected format is 'yyyy-MM-dd'T'HH:mm:ss.SSSZ'")), (Throwable)e);
        }
        String httpMaxTimestamp = System.getProperty(ALLOW_HTTP_FALLBACK_MAX_TIMESTAMP_PROPERTY, System.getProperty("mule.session.sign.http.fallback.maxTimestamp"));
        try {
            if (httpMaxTimestamp == null) {
                logger.info((Object)"    http.fallback.maxTimestamp: Disabled");
                ALLOW_HTTP_FALLBACK_MAX_TIMESTAMP = 0L;
            } else {
                logger.info((Object)("    http.fallback.maxTimestamp: " + httpMaxTimestamp));
                ALLOW_HTTP_FALLBACK_MAX_TIMESTAMP = dateFormat.parse(httpMaxTimestamp).getTime();
            }
        }
        catch (ParseException e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage((String)("Could not parse 'mule.session.serialization.http.fallback.maxTimestamp' with value '" + httpMaxTimestamp + "'. Expected format is 'yyyy-MM-dd'T'HH:mm:ss.SSSZ'")), (Throwable)e);
        }
    }

    private class FromMessageObjectSerializerLocator
    implements ObjectSerializerLocator {
        private FromMessageObjectSerializerLocator() {
        }

        @Override
        public ObjectSerializer getObjectSerializer(MuleMessage message) {
            return message.getMuleContext().getObjectSerializer();
        }
    }

    private class FixedObjectSerializerLocator
    implements ObjectSerializerLocator {
        private final ObjectSerializer objectSerializer;

        private FixedObjectSerializerLocator(ObjectSerializer objectSerializer) {
            this.objectSerializer = objectSerializer;
        }

        @Override
        public ObjectSerializer getObjectSerializer(MuleMessage message) {
            return this.objectSerializer;
        }
    }

    private static interface ObjectSerializerLocator {
        public ObjectSerializer getObjectSerializer(MuleMessage var1);
    }
}

