/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp.filters;

import org.bouncycastle.openpgp.PGPPublicKey;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityFilter;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.pgp.LiteralMessage;
import org.mule.module.pgp.Message;
import org.mule.module.pgp.MessageFactory;
import org.mule.module.pgp.PGPAuthentication;
import org.mule.module.pgp.PGPCryptInfo;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.SignedMessage;
import org.mule.module.pgp.i18n.PGPMessages;
import org.mule.security.AbstractEndpointSecurityFilter;

public class PGPSecurityFilter
extends AbstractEndpointSecurityFilter {
    private EncryptionStrategy strategy;
    private String strategyName;
    private boolean signRequired;
    private PGPKeyRing keyManager;

    protected void authenticateInbound(MuleEvent event) throws SecurityException, UnauthorisedException, UnknownAuthenticationTypeException {
        Authentication authResult;
        PGPAuthentication authentication;
        MuleMessage message = event.getMessage();
        String userId = (String)this.getCredentialsAccessor().getCredentials(event);
        byte[] creds = null;
        try {
            creds = message.getPayloadAsBytes();
            creds = this.strategy.decrypt(creds, null);
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event, (Throwable)e1);
        }
        try {
            authentication = new PGPAuthentication(userId, this.decodeMsgRaw(creds), event);
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event, (Throwable)e1);
        }
        try {
            authResult = this.getSecurityManager().authenticate((Authentication)authentication);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication request for user: " + userId + " failed: " + e.toString()));
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser((Object)userId), event, (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        event.getSession().setSecurityContext(context);
        try {
            this.updatePayload(message, this.getUnencryptedMessageWithoutSignature((PGPAuthentication)authResult), event);
        }
        catch (Exception e2) {
            throw new UnauthorisedException(event, context, (SecurityFilter)this);
        }
    }

    private Message decodeMsgRaw(byte[] raw) throws Exception {
        return MessageFactory.getMessage(raw);
    }

    private String getUnencryptedMessageWithoutSignature(PGPAuthentication auth) throws Exception {
        Message msg = (Message)auth.getCredentials();
        if (msg instanceof SignedMessage) {
            msg = ((SignedMessage)msg).getContents();
        }
        if (msg instanceof LiteralMessage) {
            return ((LiteralMessage)msg).getTextData();
        }
        throw new Exception("Wrong data");
    }

    protected void authenticateOutbound(MuleEvent event) throws SecurityException, UnauthorisedException {
        this.logger.debug((Object)("authenticateOutbound:" + event.getId()));
        if (!this.isAuthenticate()) {
            return;
        }
        MuleMessage message = event.getMessage();
        String userId = (String)this.getCredentialsAccessor().getCredentials(event);
        PGPPublicKey userKeyBundle = this.keyManager.getPublicKey(userId);
        PGPCryptInfo cryptInfo = new PGPCryptInfo(userKeyBundle, this.signRequired);
        try {
            this.updatePayload(event.getMessage(), this.strategy.encrypt(message.getPayloadAsBytes(), (Object)cryptInfo), event);
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event, (Throwable)e1);
        }
    }

    protected void doInitialise() throws InitialisationException {
        if (this.strategyName != null) {
            this.strategy = this.muleContext.getSecurityManager().getEncryptionStrategy(this.strategyName);
        }
        if (this.strategy == null) {
            throw new InitialisationException(PGPMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }

    public EncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(EncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategyName(String name) {
        this.strategyName = name;
    }

    public boolean isSignRequired() {
        return this.signRequired;
    }

    public void setSignRequired(boolean signRequired) {
        this.signRequired = signRequired;
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }
}

