/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.client.OperationOptions;
import org.mule.api.connector.ConnectorOperationProvider;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.internal.config.HttpConfiguration;
import org.mule.module.http.internal.request.client.HttpRequestCacheKey;
import org.mule.module.http.internal.request.client.HttpRequesterBuilder;
import org.mule.module.http.internal.request.client.OneWayHttpRequesterAdapter;

public class HttpConnectorMessageProcessorProvider
implements ConnectorOperationProvider,
MuleContextAware,
Disposable {
    private static final int CACHE_SIZE = 1000;
    private static final int EXPIRATION_TIME_IN_MINUTES = 10;
    private final LoadingCache<HttpRequestCacheKey, MessageProcessor> cachedMessageProcessors = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<HttpRequestCacheKey, MessageProcessor>(){

        public MessageProcessor load(HttpRequestCacheKey cacheKey) throws MuleException {
            return HttpConnectorMessageProcessorProvider.this.buildMessageProcessor(cacheKey);
        }
    });
    private MuleContext muleContext;

    public boolean supportsUrl(String url) {
        if (HttpConfiguration.useTransportForUris(this.muleContext)) {
            return false;
        }
        return url.startsWith(HttpConstants.Protocols.HTTP.getScheme()) || url.startsWith(HttpConstants.Protocols.HTTPS.getScheme());
    }

    public MessageProcessor getMessageProcessor(String url, OperationOptions operationOptions, MessageExchangePattern exchangePattern) throws MuleException {
        try {
            return (MessageProcessor)this.cachedMessageProcessors.get(new HttpRequestCacheKey<OperationOptions>(url, operationOptions, exchangePattern));
        }
        catch (ExecutionException e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private MessageProcessor buildMessageProcessor(HttpRequestCacheKey cacheKey) throws MuleException {
        Object operationOptions = cacheKey.getOperationOptions();
        MessageExchangePattern exchangePattern = cacheKey.getExchangePattern();
        String url = cacheKey.getUrl();
        HttpRequesterBuilder httpRequesterBuilder = new HttpRequesterBuilder(this.muleContext).setUrl(url);
        if (operationOptions instanceof HttpRequestOptions) {
            httpRequesterBuilder.setOperationConfig((HttpRequestOptions)operationOptions);
        } else if (operationOptions.getResponseTimeout() != null) {
            httpRequesterBuilder.responseTimeout(operationOptions.getResponseTimeout());
        }
        Object messageProcessor = httpRequesterBuilder.build();
        if (exchangePattern.equals((Object)MessageExchangePattern.ONE_WAY)) {
            messageProcessor = new OneWayHttpRequesterAdapter((MessageProcessor)messageProcessor);
        }
        return messageProcessor;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void dispose() {
        this.cachedMessageProcessors.invalidateAll();
    }
}

