/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.File;
import java.io.IOException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpUtil;
import org.mule.transport.sftp.config.SftpProxyConfig;
import org.mule.util.StringUtils;

public class SftpConnectionFactory
implements PoolableObjectFactory {
    private static final Logger logger = Logger.getLogger(SftpConnectionFactory.class);
    private final ImmutableEndpoint endpoint;
    private String preferredAuthenticationMethods;
    private SftpProxyConfig proxyConfig;

    public SftpConnectionFactory(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void activateObject(Object o) throws Exception {
    }

    public void destroyObject(Object o) throws Exception {
        SftpClient client = (SftpClient)o;
        client.disconnect();
    }

    public Object makeObject() throws Exception {
        return this.createClient();
    }

    public SftpClient createClient() throws IOException {
        EndpointURI endpointURI = this.endpoint.getEndpointURI();
        String host = endpointURI.getHost();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using host: " + host));
        }
        SftpClient client = new SftpClient(host);
        if (!StringUtils.isEmpty((String)this.preferredAuthenticationMethods)) {
            client.setPreferredAuthenticationMethods(this.preferredAuthenticationMethods);
        }
        if (this.proxyConfig != null) {
            client.setProxyConfig(this.proxyConfig);
        }
        try {
            int uriPort = endpointURI.getPort();
            if (uriPort != -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using port: " + uriPort));
                }
                client.setPort(uriPort);
            }
            client.setConnectionTimeoutMillis(this.endpoint.getResponseTimeout());
            SftpUtil sftpUtil = new SftpUtil(this.endpoint);
            String identityFile = sftpUtil.getIdentityFile();
            if (sftpUtil.getKnownHostsFile() != null) {
                client.setKnownHostsFile(new File(sftpUtil.getKnownHostsFile()));
            }
            if (identityFile != null) {
                String passphrase = sftpUtil.getPassphrase();
                client.login(endpointURI.getUser(), identityFile, passphrase);
            } else {
                client.login(endpointURI.getUser(), endpointURI.getPassword());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully connected to: " + endpointURI));
            }
            return client;
        }
        catch (IOException e) {
            client.disconnect();
            throw e;
        }
    }

    public void passivateObject(Object o) throws Exception {
    }

    public boolean validateObject(Object o) {
        SftpClient client = (SftpClient)o;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Inside validateObject - will return " + client.isConnected()));
        }
        return client.isConnected();
    }

    public void setPreferredAuthenticationMethods(String preferredAuthenticationMethods) {
        this.preferredAuthenticationMethods = preferredAuthenticationMethods;
    }

    public void setProxyConfig(SftpProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }
}

