/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.redelivery;

import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.jms.redelivery.AbstractRedeliveryHandler;
import org.mule.transport.jms.redelivery.MessageRedeliveredException;

public class JmsXRedeliveryHandler
extends AbstractRedeliveryHandler {
    protected static final Log logger = LogFactory.getLog(JmsXRedeliveryHandler.class);

    @Override
    public void handleRedelivery(Message message, InboundEndpoint endpoint, FlowConstruct flow) throws JMSException, MuleException {
        int connectorRedelivery = this.connector.getMaxRedelivery();
        if (connectorRedelivery == -1 || connectorRedelivery < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"We were asked to ignore the redelivery count, nothing to do here.");
            }
            return;
        }
        String messageId = message.getJMSMessageID();
        int deliveryCount = -1;
        try {
            deliveryCount = message.getIntProperty("JMSXDeliveryCount");
        }
        catch (NumberFormatException nex) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("Invalid use of %s. Message is flagged with JMSRedelivered, but JMSXDeliveryCount is not set", this.getClass().getName())));
        }
        int redeliveryCount = deliveryCount - 1;
        if (redeliveryCount == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + messageId + " has been redelivered for the first time"));
            }
            if (connectorRedelivery == 0) {
                MuleMessage msg = this.createMuleMessage(message, endpoint.getMuleContext());
                throw new MessageRedeliveredException(messageId, redeliveryCount, connectorRedelivery, endpoint, flow, msg);
            }
        } else {
            if (redeliveryCount > connectorRedelivery) {
                MuleMessage msg = this.createMuleMessage(message, endpoint.getMuleContext());
                throw new MessageRedeliveredException(messageId, redeliveryCount, connectorRedelivery, endpoint, flow, msg);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + messageId + " has been redelivered " + redeliveryCount + " times"));
            }
        }
    }
}

