/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.sqlstrategy;

import java.sql.Connection;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.jdbc.JdbcConnector;
import org.mule.transport.jdbc.sqlstrategy.SqlStatementStrategy;
import org.mule.util.ArrayUtils;

public class SimpleUpdateSqlStatementStrategy
implements SqlStatementStrategy {
    protected transient Logger logger = Logger.getLogger(this.getClass());

    @Override
    public MuleMessage executeStatement(JdbcConnector connector, ImmutableEndpoint endpoint, MuleEvent event, long timeout, Connection connection) throws Exception {
        String statement = connector.getStatement(endpoint);
        ArrayList<String> paramNames = new ArrayList<String>();
        String sql = connector.parseStatement(statement, paramNames);
        sql = this.escapeStatement(sql);
        MuleMessage message = event.getMessage();
        Object[] paramValues = connector.getParams(endpoint, paramNames, (MuleMessage)new DefaultMuleMessage(event.getMessage().getPayload(), message, event.getMuleContext()), endpoint.getEndpointURI().getAddress());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SQL UPDATE: " + sql + ", params = " + ArrayUtils.toString((Object)paramValues)));
        }
        int nbRows = connector.getQueryRunnerFor(endpoint).update(connection, sql, paramValues);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Executing SQL statement: " + nbRows + " row(s) updated"));
        }
        this.logger.debug((Object)"MuleEvent dispatched succesfuly");
        return event.getMessage();
    }

    protected String escapeStatement(String statement) {
        return statement;
    }
}

