/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email.transformers;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.internet.MimeMultipart;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractDiscoverableTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class EmailMessageToString
extends AbstractDiscoverableTransformer {
    public EmailMessageToString() {
        this.registerSourceType(DataTypeFactory.create(Message.class));
        this.setReturnDataType(DataTypeFactory.STRING);
    }

    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        Message msg = (Message)src;
        try {
            Object content;
            BodyPart firstBodyPart;
            Object result = msg.getContent();
            if (result instanceof String) {
                return result;
            }
            if (result instanceof MimeMultipart && (firstBodyPart = ((MimeMultipart)result).getBodyPart(0)) != null && firstBodyPart.getContentType().startsWith("text/") && (content = firstBodyPart.getContent()) instanceof String) {
                return content;
            }
            return "";
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }
}

