/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.util.Iterator;
import org.drools.RuleBase;
import org.drools.definition.process.Process;
import org.drools.event.AbstractEventSupport;
import org.drools.event.AfterFunctionRemovedEvent;
import org.drools.event.AfterPackageAddedEvent;
import org.drools.event.AfterPackageRemovedEvent;
import org.drools.event.AfterProcessAddedEvent;
import org.drools.event.AfterProcessRemovedEvent;
import org.drools.event.AfterRuleAddedEvent;
import org.drools.event.AfterRuleBaseLockedEvent;
import org.drools.event.AfterRuleBaseUnlockedEvent;
import org.drools.event.AfterRuleRemovedEvent;
import org.drools.event.BeforeFunctionRemovedEvent;
import org.drools.event.BeforePackageAddedEvent;
import org.drools.event.BeforePackageRemovedEvent;
import org.drools.event.BeforeProcessAddedEvent;
import org.drools.event.BeforeProcessRemovedEvent;
import org.drools.event.BeforeRuleAddedEvent;
import org.drools.event.BeforeRuleBaseLockedEvent;
import org.drools.event.BeforeRuleBaseUnlockedEvent;
import org.drools.event.BeforeRuleRemovedEvent;
import org.drools.event.RuleBaseEventListener;
import org.drools.rule.Package;
import org.drools.rule.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBaseEventSupport
extends AbstractEventSupport<RuleBaseEventListener> {
    private transient RuleBase ruleBase;

    public RuleBaseEventSupport() {
    }

    public RuleBaseEventSupport(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public void fireBeforePackageAdded(Package newPkg) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforePackageAddedEvent event = new BeforePackageAddedEvent(this.ruleBase, newPkg);
            do {
                ((RuleBaseEventListener)iter.next()).beforePackageAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterPackageAdded(Package newPkg) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterPackageAddedEvent event = new AfterPackageAddedEvent(this.ruleBase, newPkg);
            do {
                ((RuleBaseEventListener)iter.next()).afterPackageAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforePackageRemoved(Package pkg) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforePackageRemovedEvent event = new BeforePackageRemovedEvent(this.ruleBase, pkg);
            do {
                ((RuleBaseEventListener)iter.next()).beforePackageRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterPackageRemoved(Package pkg) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterPackageRemovedEvent event = new AfterPackageRemovedEvent(this.ruleBase, pkg);
            do {
                ((RuleBaseEventListener)iter.next()).afterPackageRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeRuleBaseLocked() {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforeRuleBaseLockedEvent event = new BeforeRuleBaseLockedEvent(this.ruleBase);
            do {
                ((RuleBaseEventListener)iter.next()).beforeRuleBaseLocked(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterRuleBaseLocked() {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterRuleBaseLockedEvent event = new AfterRuleBaseLockedEvent(this.ruleBase);
            do {
                ((RuleBaseEventListener)iter.next()).afterRuleBaseLocked(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeRuleBaseUnlocked() {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforeRuleBaseUnlockedEvent event = new BeforeRuleBaseUnlockedEvent(this.ruleBase);
            do {
                ((RuleBaseEventListener)iter.next()).beforeRuleBaseUnlocked(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterRuleBaseUnlocked() {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterRuleBaseUnlockedEvent event = new AfterRuleBaseUnlockedEvent(this.ruleBase);
            do {
                ((RuleBaseEventListener)iter.next()).afterRuleBaseUnlocked(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeRuleAdded(Package newPkg, Rule rule) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforeRuleAddedEvent event = new BeforeRuleAddedEvent(this.ruleBase, newPkg, rule);
            do {
                ((RuleBaseEventListener)iter.next()).beforeRuleAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterRuleAdded(Package newPkg, Rule rule) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterRuleAddedEvent event = new AfterRuleAddedEvent(this.ruleBase, newPkg, rule);
            do {
                ((RuleBaseEventListener)iter.next()).afterRuleAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeRuleRemoved(Package pkg, Rule rule) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforeRuleRemovedEvent event = new BeforeRuleRemovedEvent(this.ruleBase, pkg, rule);
            do {
                ((RuleBaseEventListener)iter.next()).beforeRuleRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterRuleRemoved(Package pkg, Rule rule) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterRuleRemovedEvent event = new AfterRuleRemovedEvent(this.ruleBase, pkg, rule);
            do {
                ((RuleBaseEventListener)iter.next()).afterRuleRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeFunctionRemoved(Package pkg, String function) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforeFunctionRemovedEvent event = new BeforeFunctionRemovedEvent(this.ruleBase, pkg, function);
            do {
                ((RuleBaseEventListener)iter.next()).beforeFunctionRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterFunctionRemoved(Package pkg, String function) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterFunctionRemovedEvent event = new AfterFunctionRemovedEvent(this.ruleBase, pkg, function);
            do {
                ((RuleBaseEventListener)iter.next()).afterFunctionRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeProcessAdded(Process process) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforeProcessAddedEvent event = new BeforeProcessAddedEvent(process);
            do {
                ((RuleBaseEventListener)iter.next()).beforeProcessAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterProcessAdded(Process process) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterProcessAddedEvent event = new AfterProcessAddedEvent(process);
            do {
                ((RuleBaseEventListener)iter.next()).afterProcessAdded(event);
            } while (iter.hasNext());
        }
    }

    public void fireBeforeProcessRemoved(Process process) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            BeforeProcessRemovedEvent event = new BeforeProcessRemovedEvent(process);
            do {
                ((RuleBaseEventListener)iter.next()).beforeProcessRemoved(event);
            } while (iter.hasNext());
        }
    }

    public void fireAfterProcessRemoved(Process process) {
        Iterator iter = this.getEventListenersIterator();
        if (iter.hasNext()) {
            AfterProcessRemovedEvent event = new AfterProcessRemovedEvent(process);
            do {
                ((RuleBaseEventListener)iter.next()).afterProcessRemoved(event);
            } while (iter.hasNext());
        }
    }
}

