/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.NotificationHelper;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class NotificationHelperTestCase
extends AbstractMuleTestCase {
    @Mock
    private ServerNotificationHandler defaultNotificationHandler;
    @Mock
    private ServerNotificationManager eventNotificationHandler;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent event;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleMessage message;
    private NotificationHelper helper;

    @Before
    public void before() {
        Mockito.when((Object)this.event.getMuleContext().getNotificationManager()).thenReturn((Object)this.eventNotificationHandler);
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.message.getDataType().getType()).thenReturn(String.class);
        this.initMocks((ServerNotificationHandler)this.eventNotificationHandler);
        this.initMocks(this.defaultNotificationHandler);
        this.helper = new NotificationHelper(this.defaultNotificationHandler, TestServerNotification.class, false);
    }

    private void initMocks(ServerNotificationHandler notificationHandler) {
        Mockito.when((Object)notificationHandler.isNotificationEnabled(TestServerNotification.class)).thenReturn((Object)true);
        Mockito.when((Object)notificationHandler.isNotificationEnabled(ConnectorMessageNotification.class)).thenReturn((Object)true);
    }

    @Test
    public void isNotificationEnabled() {
        Assert.assertThat((Object)this.helper.isNotificationEnabled(), (Matcher)CoreMatchers.is((Object)true));
        ((ServerNotificationHandler)Mockito.verify((Object)this.defaultNotificationHandler)).isNotificationEnabled(TestServerNotification.class);
    }

    @Test
    public void isNotificationEnabledForEvent() {
        Assert.assertThat((Object)this.helper.isNotificationEnabled(this.event), (Matcher)CoreMatchers.is((Object)true));
        ((ServerNotificationManager)Mockito.verify((Object)this.eventNotificationHandler)).isNotificationEnabled(TestServerNotification.class);
    }

    @Test
    public void fireNotificationForEvent() {
        String uri = "uri";
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        int action = 100;
        this.helper.fireNotification(this.event, "uri", flowConstruct, 100);
        this.assertConnectorMessageNotification((ServerNotificationHandler)this.eventNotificationHandler, "uri", flowConstruct, 100);
    }

    @Test
    public void fireSpecificNotificationForEvent() {
        TestServerNotification notification = new TestServerNotification();
        this.helper.fireNotification((ServerNotification)notification, this.event);
        ((ServerNotificationManager)Mockito.verify((Object)this.eventNotificationHandler)).fireNotification((ServerNotification)notification);
    }

    @Test
    public void fireSpecificNotificationOnDefaultHandler() {
        TestServerNotification notification = new TestServerNotification();
        this.helper.fireNotification((ServerNotification)notification);
        ((ServerNotificationHandler)Mockito.verify((Object)this.defaultNotificationHandler)).fireNotification((ServerNotification)notification);
    }

    private void assertConnectorMessageNotification(ServerNotificationHandler notificationHandler, String uri, FlowConstruct flowConstruct, int action) {
        ArgumentCaptor notificationCaptor = ArgumentCaptor.forClass(ConnectorMessageNotification.class);
        ((ServerNotificationHandler)Mockito.verify((Object)notificationHandler)).fireNotification((ServerNotification)notificationCaptor.capture());
        ConnectorMessageNotification notification = (ConnectorMessageNotification)notificationCaptor.getValue();
        Assert.assertThat((Object)notification.getAction(), (Matcher)CoreMatchers.is((Object)action));
        Assert.assertThat((Object)notification.getFlowConstruct(), (Matcher)CoreMatchers.is((Object)flowConstruct));
        Assert.assertThat((Object)notification.getEndpoint(), (Matcher)CoreMatchers.is((Object)uri));
    }

    private class TestServerNotification
    extends ServerNotification {
        public TestServerNotification() {
            super((Object)"", 0);
        }
    }
}

