/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.expression.ExpressionManager;
import org.mule.endpoint.DynamicURIBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DynamicURIBuilderTestCase
extends AbstractMuleTestCase {
    public static final String EXPECTED_ADDRESS = "http://admin%40abc:admin%40123@localhost:8080/test?foo=bar";
    private final MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    public static final String ATTRIBUTE_EXPRESSION = "#[expression]";

    @Test
    public void resolvesDynamicAddress() throws Exception {
        String uriTemplate = "http://admin%40abc:admin%40123@localhost:8080/#[expression]";
        this.createExpressionManager(uriTemplate, EXPECTED_ADDRESS);
        URIBuilder uriBuilder = new URIBuilder(uriTemplate, this.muleContext);
        this.doDynamicUriResolverTest(uriBuilder);
    }

    @Test
    public void resolvesDynamicPort() throws Exception {
        String templatePort = ATTRIBUTE_EXPRESSION;
        this.createExpressionManager(ATTRIBUTE_EXPRESSION, "8080");
        URIBuilder uriBuilder = this.createDefaultUriBuilder(this.muleContext);
        uriBuilder.setPort(templatePort);
        this.doDynamicUriResolverTest(uriBuilder);
    }

    @Test
    public void resolvesDynamicHost() throws Exception {
        this.createExpressionManager(ATTRIBUTE_EXPRESSION, "localhost");
        URIBuilder uriBuilder = this.createDefaultUriBuilder(this.muleContext);
        uriBuilder.setHost(ATTRIBUTE_EXPRESSION);
        this.doDynamicUriResolverTest(uriBuilder);
    }

    @Test
    public void resolvesDynamicPath() throws Exception {
        this.createExpressionManager(ATTRIBUTE_EXPRESSION, "test?foo=bar");
        URIBuilder uriBuilder = this.createDefaultUriBuilder(this.muleContext);
        uriBuilder.setPath(ATTRIBUTE_EXPRESSION);
        this.doDynamicUriResolverTest(uriBuilder);
    }

    @Test
    public void resolvesDynamicPassword() throws Exception {
        this.createExpressionManager(ATTRIBUTE_EXPRESSION, "admin@123");
        URIBuilder uriBuilder = this.createDefaultUriBuilder(this.muleContext);
        uriBuilder.setPassword(ATTRIBUTE_EXPRESSION);
        this.doDynamicUriResolverTest(uriBuilder);
    }

    @Test
    public void resolvesDynamicUser() throws Exception {
        this.createExpressionManager(ATTRIBUTE_EXPRESSION, "admin@abc");
        URIBuilder uriBuilder = this.createDefaultUriBuilder(this.muleContext);
        uriBuilder.setUser(ATTRIBUTE_EXPRESSION);
        this.doDynamicUriResolverTest(uriBuilder);
    }

    @Test(expected=MalformedEndpointException.class)
    public void throwsErrorOnInvalidUrl() throws Exception {
        URIBuilder uriBuilder = new URIBuilder("#[expression]://localhost", this.muleContext);
        DynamicURIBuilder dynamicURIBuilder = new DynamicURIBuilder(uriBuilder);
        dynamicURIBuilder.build(this.event);
    }

    private void createExpressionManager(String expression, String expressionValue) {
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)expressionManager);
        Mockito.when((Object)expressionManager.isExpression(expression)).thenReturn((Object)true);
        Mockito.when((Object)expressionManager.parse(expression, this.event, true)).thenReturn((Object)expressionValue);
    }

    private void doDynamicUriResolverTest(URIBuilder uriBuilder) throws URISyntaxException, UnsupportedEncodingException, MalformedEndpointException {
        DynamicURIBuilder dynamicURIBuilder = new DynamicURIBuilder(uriBuilder);
        String uri = dynamicURIBuilder.build(this.event);
        Assert.assertThat((Object)uri, (Matcher)CoreMatchers.equalTo((Object)EXPECTED_ADDRESS));
    }

    private URIBuilder createDefaultUriBuilder(MuleContext muleContext) {
        URIBuilder uriBuilder = new URIBuilder(muleContext);
        uriBuilder.setUser("admin@abc");
        uriBuilder.setPassword("admin@123");
        uriBuilder.setHost("localhost");
        uriBuilder.setPath("test?foo=bar");
        uriBuilder.setProtocol("http");
        uriBuilder.setPort("8080");
        return uriBuilder;
    }
}

