/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.TrackerWorkListener;
import org.mule.transport.WorkEventMatcher;

@SmallTest
public class TrackerWorkListenerTestCase
extends AbstractMuleTestCase {
    public static final int START_DURATION = 10;
    private final Work originalWork = (Work)Mockito.mock(Work.class);
    private final Work work = (Work)Mockito.mock(Work.class);
    private final WorkException workException = new WorkException();
    private final WorkListener delegate = (WorkListener)Mockito.mock(WorkListener.class);
    private final TrackerWorkListener trackerWorkListener = new TrackerWorkListener(this.work, this.delegate);

    @Test
    public void notifiesWorkAccepted() {
        WorkEvent workEvent = this.createWorkEvent(1);
        this.trackerWorkListener.workAccepted(workEvent);
        ((WorkListener)Mockito.verify((Object)this.delegate)).workAccepted(WorkEventMatcher.anAcceptedWorkEventFor(this, this.work, this.workException, 10L));
    }

    @Test
    public void notifiesWorkCompleted() {
        WorkEvent workEvent = this.createWorkEvent(4);
        this.trackerWorkListener.workCompleted(workEvent);
        ((WorkListener)Mockito.verify((Object)this.delegate)).workCompleted(WorkEventMatcher.aCompletedWorkEventFor(this, this.work, this.workException, 10L));
    }

    @Test
    public void notifiesWorkRejected() {
        WorkEvent workEvent = this.createWorkEvent(2);
        this.trackerWorkListener.workRejected(workEvent);
        ((WorkListener)Mockito.verify((Object)this.delegate)).workRejected(WorkEventMatcher.aRejectedWorkEventFor(this, this.work, this.workException, 10L));
    }

    @Test
    public void notifiesWorkStarted() {
        int workStarted = 3;
        this.trackerWorkListener.workStarted(this.createWorkEvent(workStarted));
        ((WorkListener)Mockito.verify((Object)this.delegate)).workStarted(WorkEventMatcher.aStartedWorkEventFor(this, this.work, this.workException, 10L));
    }

    private WorkEvent createWorkEvent(int type) {
        return new WorkEvent((Object)this, type, this.originalWork, this.workException, 10L);
    }
}

