/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jibx.schema.ISchemaListener;
import org.jibx.schema.NameRegister;
import org.jibx.schema.SchemaContextTracker;
import org.jibx.schema.SchemaUtils;
import org.jibx.schema.SchemaVisitor;
import org.jibx.schema.TreeWalker;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.AttributeGroupRefElement;
import org.jibx.schema.elements.CommonTypeDefinition;
import org.jibx.schema.elements.ComplexExtensionElement;
import org.jibx.schema.elements.ComplexRestrictionElement;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.GroupRefElement;
import org.jibx.schema.elements.ListElement;
import org.jibx.schema.elements.OpenAttrBase;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.schema.elements.SimpleExtensionElement;
import org.jibx.schema.elements.SimpleRestrictionElement;
import org.jibx.schema.elements.UnionElement;
import org.jibx.util.ReferenceCountMap;

public class UsageFinder {
    private static final Logger s_logger = Logger.getLogger((String)UsageFinder.class.getName());
    private final UsageVisitor m_visitor = new UsageVisitor();

    public ReferenceCountMap getUsageMap() {
        return this.m_visitor.getUsageMap();
    }

    public Set getNonSingletonSet() {
        return this.m_visitor.getNonSingletonSet();
    }

    public void countSchemaTree(SchemaElement schema) {
        TreeWalker wlkr = new TreeWalker(null, this.m_visitor.getListener());
        wlkr.walkSchema(schema, this.m_visitor);
    }

    public void addReferenceClosure(AnnotatedBase comp) {
        this.m_visitor.addReferenceClosure(comp);
    }

    public void addReferenceClosure(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.addReferenceClosure((AnnotatedBase)iter.next());
        }
    }

    public void setNameRegister(NameRegister reg) {
        this.m_visitor.setNameRegister(reg);
    }

    public void reset() {
        this.m_visitor.reset();
    }

    private static class UsageVisitor
    extends SchemaVisitor {
        private final SchemaContextTracker m_tracker = new SchemaContextTracker();
        private final ReferenceCountMap m_usageMap = new ReferenceCountMap();
        private final Set m_nonSingletonSet = new HashSet();
        private ArrayList m_newReferences;

        public ISchemaListener getListener() {
            return this.m_tracker;
        }

        private void countUse(Object obj) {
            AnnotatedBase comp;
            if (obj != null && (comp = (AnnotatedBase)obj).getParent() != null) {
                s_logger.debug((Object)(" incrementing usage count for " + SchemaUtils.describeComponent(comp)));
                if (this.m_usageMap.incrementCount((Object)comp) == 1 && this.m_newReferences != null) {
                    if (comp.getParent() instanceof SchemaElement) {
                        s_logger.debug((Object)"  (first use for component, added to new references list)");
                        this.m_newReferences.add(obj);
                    } else if (((AnnotatedBase)obj).getParent() != null) {
                        throw new IllegalStateException("Internal error: non-global in usage counts");
                    }
                }
            }
        }

        private void addNonSingleton(Object obj) {
            if (obj != null && this.m_nonSingletonSet.add(obj)) {
                s_logger.debug((Object)(" flagged non-singleton use of " + SchemaUtils.describeComponent((AnnotatedBase)obj)));
            }
        }

        public void addReferenceClosure(AnnotatedBase comp) {
            if (this.m_newReferences == null) {
                this.m_newReferences = new ArrayList();
            }
            s_logger.debug((Object)("adding reference closure for " + SchemaUtils.describeComponent(comp)));
            int base = this.m_newReferences.size();
            this.countUse(comp);
            TreeWalker wlkr = new TreeWalker(null, this.m_tracker);
            while (this.m_newReferences.size() > base) {
                int limit = this.m_newReferences.size();
                if (base > 0) {
                    s_logger.debug((Object)(" found " + (limit - base) + " new references in expansion pass"));
                }
                for (int i = base; i < limit; ++i) {
                    AnnotatedBase ref = (AnnotatedBase)this.m_newReferences.get(i);
                    OpenAttrBase parent = ref.getParent();
                    if (parent instanceof SchemaElement) {
                        s_logger.debug((Object)(" adding reference closure for " + SchemaUtils.describeComponent(ref)));
                        this.m_tracker.setNameRegister(((SchemaElement)parent).getRegister());
                        wlkr.walkElement(ref, this);
                        continue;
                    }
                    s_logger.debug((Object)(" reference closure with non-global definition " + ref));
                }
                base = limit;
            }
        }

        public void setNameRegister(NameRegister reg) {
            this.m_tracker.setNameRegister(reg);
        }

        public ReferenceCountMap getUsageMap() {
            return this.m_usageMap;
        }

        public Set getNonSingletonSet() {
            return this.m_nonSingletonSet;
        }

        public void reset() {
            this.m_usageMap.clear();
            this.m_nonSingletonSet.clear();
            this.m_newReferences = null;
        }

        public void exit(AttributeElement node) {
            this.countUse(node.getReference());
            if (node.getType() != null) {
                this.countUse(node.getTypeDefinition());
            }
        }

        public void exit(AttributeGroupRefElement node) {
            this.countUse(node.getReference());
        }

        public void exit(ComplexExtensionElement node) {
            this.countUse(node.getBaseType());
        }

        public void exit(ComplexRestrictionElement node) {
            this.countUse(node.getBaseType());
        }

        public void exit(ElementElement node) {
            if (node.getRef() != null) {
                this.countUse(node.getReference());
                if (!SchemaUtils.isSingletonElement(node)) {
                    this.addNonSingleton(node.getReference());
                }
            } else if (node.getType() != null) {
                this.countUse(node.getTypeDefinition());
                if (!SchemaUtils.isSingletonElement(node)) {
                    this.addNonSingleton(node.getTypeDefinition());
                }
            }
        }

        public void exit(GroupRefElement node) {
            this.countUse(node.getReference());
            if (!SchemaUtils.isSingleton(node)) {
                this.addNonSingleton(node);
            }
        }

        public void exit(ListElement node) {
            this.countUse(node.getItemTypeDefinition());
        }

        public void exit(SimpleExtensionElement node) {
            this.countUse(node.getBaseType());
        }

        public void exit(SimpleRestrictionElement node) {
            if (node.getBase() != null) {
                this.countUse(node.getBaseType());
            }
        }

        public void exit(UnionElement node) {
            CommonTypeDefinition[] types = node.getMemberTypeDefinitions();
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    this.countUse(types[i]);
                }
            }
        }
    }
}

