/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.construct;

import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.cache.CachingStrategy;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractConfigurationPattern;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.endpoint.DynamicURIBuilder;
import org.mule.endpoint.DynamicURIOutboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.transformer.TransformerTemplate;
import org.mule.transformer.simple.MessagePropertiesTransformer;
import org.mule.transport.http.construct.support.CopyInboundToOutboundPropertiesTransformerCallback;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;

public class HttpProxy
extends AbstractConfigurationPattern {
    private final OutboundEndpoint outboundEndpoint;
    private final CachingStrategy cachingStrategy;

    public HttpProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, List<MessageProcessor> transformers, List<MessageProcessor> responseTransformers, CachingStrategy cachingStrategy) throws MuleException {
        super(name, muleContext, transformers, responseTransformers);
        if (messageSource == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)("messageSource can't be null on: " + this.toString())), (FlowConstruct)this);
        }
        super.setMessageSource(messageSource);
        if (outboundEndpoint == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)("outboundEndpoint can't be null on: " + this.toString())), (FlowConstruct)this);
        }
        this.outboundEndpoint = outboundEndpoint;
        this.cachingStrategy = cachingStrategy;
    }

    protected void configureMessageProcessorsBeforeTransformation(MessageProcessorChainBuilder builder) {
        HttpProxy.configureContentLengthRemover(this, builder);
    }

    protected void configureMessageProcessorsAfterTransformation(MessageProcessorChainBuilder builder) throws MuleException {
        Object proxyMessageProcessor;
        TransformerTemplate copyInboundToOutboundPropertiesTransformer = new TransformerTemplate((TransformerTemplate.TransformerCallback)new CopyInboundToOutboundPropertiesTransformerCallback());
        DefaultMessageProcessorChainBuilder proxyBuilder = new DefaultMessageProcessorChainBuilder();
        proxyBuilder.chain(new MessageProcessor[]{copyInboundToOutboundPropertiesTransformer});
        proxyBuilder.chain(new MessageProcessor[]{new ResponseMessageProcessorAdapter((MessageProcessor)copyInboundToOutboundPropertiesTransformer)});
        if (this.outboundEndpoint instanceof DynamicURIOutboundEndpoint) {
            proxyBuilder.chain(new MessageProcessor[]{this.outboundEndpoint});
        } else {
            OutboundEndpoint dynamicOutboundEndpoint;
            proxyBuilder.chain(new MessageProcessor[]{new TransformerTemplate(new TransformerTemplate.TransformerCallback(){

                public Object doTransform(MuleMessage message) throws Exception {
                    String pathExtension = StringUtils.substringAfter((String)((String)message.getInboundProperty("http.request")), (String)((String)message.getInboundProperty("http.context.path")));
                    message.setInvocationProperty("http.path.extension", (Object)StringUtils.defaultString((String)pathExtension));
                    return message;
                }
            })});
            if (this.outboundEndpoint.isDynamic()) {
                dynamicOutboundEndpoint = this.outboundEndpoint;
            } else {
                String uriTemplate = this.outboundEndpoint.getEndpointURI().getUri().toString() + "#[variable:http.path.extension]";
                URIBuilder uriBuilder = new URIBuilder(uriTemplate, this.muleContext);
                DynamicURIBuilder dynamicURIBuilder = new DynamicURIBuilder(uriBuilder);
                dynamicOutboundEndpoint = new DynamicOutboundEndpoint((EndpointBuilder)new EndpointURIEndpointBuilder((ImmutableEndpoint)this.outboundEndpoint), dynamicURIBuilder);
            }
            proxyBuilder.chain(new MessageProcessor[]{dynamicOutboundEndpoint});
        }
        if (this.cachingStrategy != null) {
            final MessageProcessorChain cachedMessageProcessors = proxyBuilder.build();
            proxyMessageProcessor = new MessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    return HttpProxy.this.cachingStrategy.process(event, (MessageProcessor)cachedMessageProcessors);
                }
            };
        } else {
            proxyMessageProcessor = proxyBuilder.build();
        }
        builder.chain(new MessageProcessor[]{proxyMessageProcessor});
    }

    public static void configureContentLengthRemover(AbstractConfigurationPattern configurationPattern, MessageProcessorChainBuilder builder) {
        if (configurationPattern.hasTransformers() || configurationPattern.hasResponseTransformers()) {
            MessagePropertiesTransformer contentLengthHeaderRemover = HttpProxy.newContentLengthHeaderRemover();
            if (configurationPattern.hasTransformers()) {
                builder.chain(new MessageProcessor[]{contentLengthHeaderRemover});
            }
            if (configurationPattern.hasResponseTransformers()) {
                builder.chain(new MessageProcessor[]{new ResponseMessageProcessorAdapter((MessageProcessor)contentLengthHeaderRemover)});
            }
        }
    }

    private static MessagePropertiesTransformer newContentLengthHeaderRemover() {
        MessagePropertiesTransformer contentLengthHeaderRemover = new MessagePropertiesTransformer();
        contentLengthHeaderRemover.setScope(PropertyScope.INBOUND);
        contentLengthHeaderRemover.setDeleteProperties(new String[]{"(?i)content-length"});
        return contentLengthHeaderRemover;
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
        InboundEndpoint inboundEndpoint;
        super.validateConstruct();
        if (this.messageSource instanceof InboundEndpoint && !(inboundEndpoint = (InboundEndpoint)this.messageSource).getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"HttpProxy only works with a request-response inbound endpoint."), (FlowConstruct)this);
        }
        if (!this.outboundEndpoint.getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"HttpProxy only works with a request-response outbound endpoint."), (FlowConstruct)this);
        }
    }

    public String toString() {
        return ObjectUtils.toString((Object)((Object)this));
    }

    public String getConstructType() {
        return "HTTP-Proxy";
    }
}

