/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv1.ParserV1Utils;
import org.mule.raml.implv1.model.ResourceImpl;
import org.mule.raml.implv1.model.SecuritySchemeImpl;
import org.mule.raml.implv1.model.TemplateImpl;
import org.mule.raml.implv1.model.parameter.ParameterImpl;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.ISecurityScheme;
import org.mule.raml.interfaces.model.ITemplate;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.SecurityScheme;
import org.raml.model.Template;
import org.raml.model.parameter.AbstractParam;
import org.raml.parser.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlImplV1
implements IRaml {
    private final Logger logger;
    private Raml raml;
    private String ramlPath;
    private ResourceLoader resourceLoader;

    public RamlImplV1(Raml raml) {
        this.raml = raml;
        this.logger = LoggerFactory.getLogger(RamlImplV1.class);
    }

    public RamlImplV1(Raml raml, String ramlPath, ResourceLoader resourceLoader) {
        this.raml = raml;
        this.ramlPath = ramlPath;
        this.resourceLoader = resourceLoader;
        this.logger = LoggerFactory.getLogger(RamlImplV1.class);
    }

    public Raml getRaml() {
        return this.raml;
    }

    @Override
    public IResource getResource(String s) {
        Resource resource = this.raml.getResource(s);
        if (resource == null) {
            return null;
        }
        return new ResourceImpl(resource);
    }

    @Override
    public Map<String, String> getConsolidatedSchemas() {
        return this.raml.getConsolidatedSchemas();
    }

    @Override
    public Map<String, Object> getCompiledSchemas() {
        return this.raml.getCompiledSchemas();
    }

    @Override
    public String getBaseUri() {
        return this.raml.getBaseUri();
    }

    @Override
    public Map<String, IResource> getResources() {
        if (this.raml.getResources() == null) {
            return null;
        }
        LinkedHashMap<String, IResource> map = new LinkedHashMap<String, IResource>();
        for (Map.Entry entry : this.raml.getResources().entrySet()) {
            map.put((String)entry.getKey(), (IResource)new ResourceImpl((Resource)entry.getValue()));
        }
        return map;
    }

    @Override
    public String getVersion() {
        return this.raml.getVersion();
    }

    public void setBaseUri(String s) {
        this.raml.setBaseUri(s);
    }

    @Override
    public Map<String, IParameter> getBaseUriParameters() {
        if (this.raml.getBaseUriParameters() == null) {
            return null;
        }
        LinkedHashMap<String, IParameter> map = new LinkedHashMap<String, IParameter>();
        for (Map.Entry entry : this.raml.getBaseUriParameters().entrySet()) {
            map.put((String)entry.getKey(), (IParameter)new ParameterImpl((AbstractParam)entry.getValue()));
        }
        return map;
    }

    @Override
    public List<Map<String, ISecurityScheme>> getSecuritySchemes() {
        if (this.raml.getSecuritySchemes() == null) {
            return null;
        }
        ArrayList<Map<String, ISecurityScheme>> list = new ArrayList<Map<String, ISecurityScheme>>();
        for (Map map : this.raml.getSecuritySchemes()) {
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                newMap.put(entry.getKey(), new SecuritySchemeImpl((SecurityScheme)entry.getValue()));
            }
            list.add(newMap);
        }
        return list;
    }

    @Override
    public List<Map<String, ITemplate>> getTraits() {
        if (this.raml.getTraits() == null) {
            return null;
        }
        ArrayList<Map<String, ITemplate>> list = new ArrayList<Map<String, ITemplate>>();
        for (Map map : this.raml.getTraits()) {
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                newMap.put(entry.getKey(), new TemplateImpl((Template)entry.getValue()));
            }
            list.add(newMap);
        }
        return list;
    }

    @Override
    public String getUri() {
        return this.raml.getUri();
    }

    @Override
    public List<Map<String, String>> getSchemas() {
        return this.raml.getSchemas();
    }

    @Override
    public Object getInstance() {
        return this.raml;
    }

    @Override
    public void cleanBaseUriParameters() {
        this.raml.getBaseUriParameters().clear();
    }

    @Override
    public void injectTrait(String name) {
        HashMap traitDef = new HashMap();
        Template template = new Template();
        template.setDisplayName(name);
        HashMap map = new HashMap();
        for (Map.Entry entry : traitDef.entrySet()) {
            map.put(entry.getKey(), template);
        }
        this.raml.getTraits().add(map);
    }

    @Override
    public void injectSecurityScheme(Map<String, ISecurityScheme> securityScheme) {
        HashMap<String, SecurityScheme> map = new HashMap<String, SecurityScheme>();
        for (Map.Entry<String, ISecurityScheme> entry : securityScheme.entrySet()) {
            map.put(entry.getKey(), (SecurityScheme)entry.getValue().getInstance());
        }
        this.raml.getSecuritySchemes().add(map);
    }

    @Override
    public List<String> getAllReferences() {
        try {
            return ParserV1Utils.detectIncludes(this.ramlPath.replace("/", File.separator), this.resourceLoader);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    public String getRamlPath() {
        return this.ramlPath;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

