/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.implv2.v10.model.ResourceImpl;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.ISecurityScheme;
import org.mule.raml.interfaces.model.ITemplate;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ExternalTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.resources.Resource;
import org.raml.v2.internal.impl.RamlBuilder;
import org.raml.v2.internal.impl.commons.nodes.LibraryNodeProvider;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.snakeyaml.SYIncludeNode;

public class RamlImpl10V2
implements IRaml {
    public static final String PARSER_V2_PROPERTY = "apikit.raml.parser.v2";
    private static final String RAML_PATH_SEPARATOR = "/";
    private final String ramlPath;
    private final ResourceLoader resourceLoader;
    private Api api;
    private Optional<String> version;
    private static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

    public RamlImpl10V2(Api api, ResourceLoader resourceLoader, String ramlPath) {
        this.api = api;
        this.ramlPath = ramlPath;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Map<String, IResource> getResources() {
        LinkedHashMap<String, IResource> map = new LinkedHashMap<String, IResource>();
        List resources = this.api.resources();
        for (Resource resource : resources) {
            map.put(resource.relativeUri().value(), (IResource)new ResourceImpl(resource));
        }
        return map;
    }

    @Override
    public String getBaseUri() {
        return ParserV2Utils.nullSafe(this.api.baseUri());
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = Optional.fromNullable((Object)ParserV2Utils.nullSafe(this.api.version()));
        }
        return (String)this.version.orNull();
    }

    @Override
    public List<Map<String, String>> getSchemas() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List types = this.api.types();
        if (types.isEmpty()) {
            types = this.api.schemas();
        }
        for (TypeDeclaration typeDeclaration : types) {
            map.put(typeDeclaration.name(), RamlImpl10V2.getTypeAsString(typeDeclaration));
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        result.add(map);
        return result;
    }

    static String getTypeAsString(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof ExternalTypeDeclaration) {
            return ((ExternalTypeDeclaration)typeDeclaration).schemaContent();
        }
        if (typeDeclaration instanceof AnyTypeDeclaration) {
            return null;
        }
        return "[yaml-type-flag]";
    }

    @Override
    public IResource getResource(String path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> getConsolidatedSchemas() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getCompiledSchemas() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, IParameter> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Map<String, ISecurityScheme>> getSecuritySchemes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Map<String, ITemplate>> getTraits() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUri() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void injectTrait(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void injectSecurityScheme(Map<String, ISecurityScheme> securityScheme) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllReferences() {
        try {
            return RamlImpl10V2.findIncludeNodes(this.getPathAsUri(this.ramlPath), this.resourceLoader);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private URI getPathAsUri(String path) {
        String normalizedPath = path.replace(File.separator, RAML_PATH_SEPARATOR);
        return URI.create(normalizedPath);
    }

    public static List<String> findIncludeNodes(URI ramlURI, ResourceLoader resourceLoader) throws IOException {
        String rootPath = RamlImpl10V2.getParent(ramlURI);
        return RamlImpl10V2.findIncludeNodes(rootPath, ramlURI, resourceLoader);
    }

    public static List<String> findIncludeNodes(String rootPath, URI ramlURI, ResourceLoader resourceLoader) throws IOException {
        Node raml;
        InputStream is = resourceLoader.fetchResource(URLDecoder.decode(ramlURI.toString()));
        if (is == null) {
            return Collections.emptyList();
        }
        try {
            raml = new RamlBuilder().build(IOUtils.toString((InputStream)is));
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        return RamlImpl10V2.findIncludeNodes(rootPath, raml, resourceLoader);
    }

    public static List<String> findIncludeNodes(String rootPath, Node raml, ResourceLoader resourceLoader) throws IOException {
        HashSet<String> includePaths = new HashSet<String>();
        RamlImpl10V2.findIncludeNodes(rootPath, "", includePaths, Collections.singletonList(raml), resourceLoader);
        return new ArrayList<String>(includePaths);
    }

    private static void findIncludeNodes(String rootPath, String pathRelativeToRoot, Set<String> includePaths, List<Node> currents, ResourceLoader resourceLoader) throws IOException {
        Iterator<Node> iterator = currents.iterator();
        while (iterator.hasNext()) {
            Node current;
            String pathRelativeToRootCurrent = pathRelativeToRoot;
            for (Node possibleInclude = current = iterator.next(); possibleInclude != null; possibleInclude = possibleInclude.getSource()) {
                String includePath = null;
                if (possibleInclude instanceof SYIncludeNode) {
                    includePath = ((SYIncludeNode)possibleInclude).getIncludePath();
                } else if (possibleInclude instanceof LibraryLinkNode) {
                    includePath = ((LibraryLinkNode)possibleInclude).getRefName();
                }
                if (includePath == null) continue;
                String absolutIncludePath = RamlImpl10V2.computeIncludePath(rootPath, pathRelativeToRoot, includePath);
                URI includedFileAsUri = URI.create(URLEncoder.encode(absolutIncludePath)).normalize();
                includePaths.add(URLDecoder.decode(includedFileAsUri.toString()));
                includePaths.addAll(RamlImpl10V2.findIncludeNodes(rootPath, includedFileAsUri, resourceLoader));
                pathRelativeToRootCurrent = RamlImpl10V2.calculateNextRootRelative(pathRelativeToRootCurrent, includePath);
            }
            RamlImpl10V2.findIncludeNodes(rootPath, pathRelativeToRootCurrent, includePaths, RamlImpl10V2.getChildren(current), resourceLoader);
        }
    }

    private static String computeIncludePath(String rootPath, String pathRelativeToRoot, String includePath) {
        String absolutePath = RamlImpl10V2.isAbsolute(includePath) ? rootPath + includePath : rootPath + (pathRelativeToRoot.isEmpty() ? "" : RAML_PATH_SEPARATOR + pathRelativeToRoot) + RAML_PATH_SEPARATOR + includePath;
        return RamlImpl10V2.fixExchangeModulePath(absolutePath);
    }

    private static boolean isAbsolute(String includePath) {
        return includePath.startsWith(RAML_PATH_SEPARATOR);
    }

    private static String getParent(URI uri) {
        URI parentUri = uri.getPath().endsWith(RAML_PATH_SEPARATOR) ? uri.resolve("..") : uri.resolve(".");
        String parentUriAsString = parentUri.toString();
        return parentUriAsString.endsWith(RAML_PATH_SEPARATOR) ? parentUriAsString.substring(0, parentUriAsString.length() - 1) : parentUriAsString;
    }

    private static String fixExchangeModulePath(String path) {
        return RamlImpl10V2.getExchangeModulePath(path);
    }

    private static String calculateNextRootRelative(String pathRelativeToRootCurrent, String includePath) {
        String newRelativeSubPath = RamlImpl10V2.getParent(URI.create(URLEncoder.encode(includePath)));
        newRelativeSubPath = newRelativeSubPath == null ? "" : URLDecoder.decode(newRelativeSubPath);
        return pathRelativeToRootCurrent + newRelativeSubPath;
    }

    private static List<Node> getChildren(Node node) {
        if (node instanceof LibraryLinkNode) {
            node = ((LibraryLinkNode)node).getRefNode();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        if (node != null) {
            LibraryNodeProvider libraryNodeProvider;
            Node libraryNode;
            if (node instanceof LibraryNodeProvider && (libraryNode = (libraryNodeProvider = (LibraryNodeProvider)node).getLibraryNode()) != null) {
                result.add(libraryNode);
            }
            result.addAll(node.getChildren());
        }
        return result;
    }

    public static String getExchangeModulePath(String path) {
        Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path);
        if (matcher.find()) {
            String matching = matcher.group(0);
            int dependencyIndex = path.lastIndexOf(matching);
            if (dependencyIndex <= 0) {
                return path;
            }
            String rootPath = path.substring(0, path.indexOf(matching));
            String exchangeModulePath = path.substring(dependencyIndex);
            return Paths.get(rootPath + RAML_PATH_SEPARATOR + exchangeModulePath, new String[0]).normalize().toString();
        }
        return path;
    }
}

