/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.SystemPropertyUtils;
import org.w3c.dom.Element;

public class GlobalPropertyDefinitionParser
extends MuleOrphanDefinitionParser {
    private final String VALUE_ATTR = "value";
    private final String NAME_ATTR = "name";

    public GlobalPropertyDefinitionParser() {
        super(true);
        this.addIgnored("name");
        this.addIgnored("value");
    }

    protected Class getBeanClass(Element element) {
        return String.class;
    }

    @Override
    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        String name = element.getAttribute("name");
        if (name.indexOf(32) != -1) {
            this.logger.warn((Object)("Environment property name should not contain spaces: \"" + name + "\""));
        }
        this.solvePlaceholderValue(assembler, element, name);
        super.postProcess(context, assembler, element);
    }

    private void solvePlaceholderValue(BeanAssembler assembler, Element element, String name) {
        String solvedValue = assembler.resolvePlaceholder(this.wrapPlaceholder(name));
        if (solvedValue != null) {
            assembler.getBean().addConstructorArgValue((Object)solvedValue);
        } else {
            assembler.getBean().addConstructorArgValue((Object)this.solveGlobalPropertyValue(assembler, element));
        }
    }

    private String solveGlobalPropertyValue(BeanAssembler assembler, Element element) {
        String value = element.getAttribute("value");
        String solvedValue = assembler.resolvePlaceholder(value);
        if (solvedValue == null) {
            solvedValue = SystemPropertyUtils.resolvePlaceholders((String)value);
        }
        return value;
    }

    private String wrapPlaceholder(String name) {
        return "${" + name + "}";
    }
}

