/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class TestAppender
extends AbstractAppender {
    private Set<Expectation> expectations = new HashSet<Expectation>();

    public void clear() {
        this.expectations.clear();
    }

    public void ensure(Expectation ... expectationsToCheck) {
        HashSet<Expectation> s = new HashSet<Expectation>();
        s.addAll(Arrays.asList(expectationsToCheck));
        this.ensure(s);
    }

    public void ensure(Set<Expectation> expectationsToCheck) {
        if (!this.expectations.equals(expectationsToCheck)) {
            throw new AssertionFailedError(this.difference(expectationsToCheck, this.expectations));
        }
    }

    private String difference(Set<Expectation> expected, Set<Expectation> actual) {
        StringBuilder builder = new StringBuilder();
        this.addCollection(builder, CollectionUtils.subtract(actual, expected), "Not expected but received:");
        this.addCollection(builder, CollectionUtils.subtract(expected, actual), "Expected but not received:");
        return builder.toString();
    }

    private void addCollection(StringBuilder builder, Collection items, String description) {
        if (items != null && !items.isEmpty()) {
            builder.append('\n').append(description);
            for (Object item : items) {
                builder.append('\n').append(item);
            }
        }
    }

    public TestAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
    }

    public TestAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
    }

    public void append(LogEvent event) {
        this.expectations.add(new Expectation(event.getLevel().toString(), event.getLoggerName(), event.getMessage().getFormattedMessage()));
    }

    public static class Expectation {
        private String level;
        private String category;
        private String message;

        public Expectation(String level, String category, String message) {
            this.level = level;
            this.category = category;
            this.message = message;
        }

        public String toString() {
            return String.format("Expectation {level='%s', category='%s', message='%s'}", this.level, this.category, this.message);
        }

        public boolean equals(Object other) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }
    }
}

