/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.api.exception.MessagingExceptionHandlerAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.FlowConstructLifecycleManager;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.routing.MuleMessageInfoMapping;
import org.mule.util.ClassUtils;

public abstract class AbstractFlowConstruct
extends AbstractAnnotatedObject
implements FlowConstruct,
Lifecycle {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected String name;
    protected MessagingExceptionHandler exceptionListener;
    protected final FlowConstructLifecycleManager lifecycleManager;
    protected final MuleContext muleContext;
    protected FlowConstructStatistics statistics;
    protected MessageInfoMapping messageInfoMapping = new MuleMessageInfoMapping();
    public static final String INITIAL_STATE_STOPPED = "stopped";
    public static final String INITIAL_STATE_STARTED = "started";
    protected String initialState = "started";

    public AbstractFlowConstruct(String name, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.name = name;
        this.lifecycleManager = new FlowConstructLifecycleManager(this, muleContext);
    }

    @Override
    public final void initialise() throws InitialisationException {
        try {
            if (this.exceptionListener == null) {
                this.exceptionListener = this.muleContext.getDefaultExceptionStrategy();
            }
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    AbstractFlowConstruct.this.injectFlowConstructMuleContext(AbstractFlowConstruct.this.exceptionListener);
                    AbstractFlowConstruct.this.initialiseIfInitialisable(AbstractFlowConstruct.this.exceptionListener);
                    AbstractFlowConstruct.this.validateConstruct();
                    AbstractFlowConstruct.this.doInitialise();
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public final void start() throws MuleException {
        if (!this.isStopped() && this.initialState.equals(INITIAL_STATE_STOPPED)) {
            this.lifecycleManager.fireStartPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.lifecycleManager.fireStopPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.logger.info((Object)("Flow " + this.name + " has not been started (initial state = 'stopped')"));
            return;
        }
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractFlowConstruct.this.startIfStartable(AbstractFlowConstruct.this.exceptionListener);
                AbstractFlowConstruct.this.doStart();
            }
        });
    }

    @Override
    public final void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractFlowConstruct.this.doStop();
                AbstractFlowConstruct.this.stopIfStoppable(AbstractFlowConstruct.this.exceptionListener);
            }
        });
    }

    @Override
    public final void dispose() {
        try {
            if (this.isStarted()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    AbstractFlowConstruct.this.doDispose();
                    AbstractFlowConstruct.this.disposeIfDisposable(AbstractFlowConstruct.this.exceptionListener);
                }
            });
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to stop service: " + this.name), (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    public boolean isStopping() {
        return this.lifecycleManager.getState().isStopping();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MessagingExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public FlowConstructStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public MessageInfoMapping getMessageInfoMapping() {
        return this.messageInfoMapping;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }

    protected void doInitialise() throws MuleException {
        this.configureStatistics();
    }

    protected void configureStatistics() {
        this.statistics = new FlowConstructStatistics(this.getConstructType(), this.name);
        this.statistics.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.statistics);
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doDispose() {
        this.muleContext.getStatistics().remove(this.statistics);
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
        if (this.exceptionListener instanceof MessagingExceptionHandlerAcceptor && !((MessagingExceptionHandlerAcceptor)this.exceptionListener).acceptsAll()) {
            throw new FlowConstructInvalidException(CoreMessages.createStaticMessage("Flow exception listener contains an exception strategy that doesn't handle all request, Perhaps there's an exception strategy with a when attribute set but it's not part of a catch exception strategy"), this);
        }
    }

    protected void injectFlowConstructMuleContext(Object candidate) {
        if (candidate instanceof FlowConstructAware) {
            ((FlowConstructAware)candidate).setFlowConstruct(this);
        }
        if (candidate instanceof MuleContextAware) {
            ((MuleContextAware)candidate).setMuleContext(this.muleContext);
        }
    }

    protected void injectExceptionHandler(Object candidate) {
        if (candidate instanceof MessagingExceptionHandlerAware) {
            ((MessagingExceptionHandlerAware)candidate).setMessagingExceptionHandler(this.getExceptionListener());
        }
    }

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    protected void initialiseIfInitialisable(Object candidate) throws InitialisationException {
        if (candidate instanceof Initialisable) {
            ((Initialisable)candidate).initialise();
        }
    }

    protected void startIfStartable(Object candidate) throws MuleException {
        if (candidate instanceof Startable) {
            ((Startable)candidate).start();
        }
    }

    protected void stopIfStoppable(Object candidate) throws MuleException {
        if (candidate instanceof Stoppable) {
            ((Stoppable)candidate).stop();
        }
    }

    protected void disposeIfDisposable(Object candidate) {
        if (candidate instanceof Disposable) {
            ((Disposable)candidate).dispose();
        }
    }

    public abstract String getConstructType();
}

