/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.NonBlockingSupported;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.DynamicPipeline;
import org.mule.api.processor.DynamicPipelineBuilder;
import org.mule.api.processor.DynamicPipelineException;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.Flow;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.AbstractMessageProcessorChain;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.processor.chain.SimpleMessageProcessorChain;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public class DynamicPipelineMessageProcessor
extends AbstractInterceptingMessageProcessor
implements DynamicPipeline,
NonBlockingSupported {
    private String pipelineId;
    private AbstractMessageProcessorChain preChain;
    private AbstractMessageProcessorChain postChain;
    private MessageProcessor staticChain;
    private Flow flow;

    public DynamicPipelineMessageProcessor(Flow flow) {
        this.flow = flow;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        return this.processNext(event);
    }

    @Override
    public void setListener(MessageProcessor next) {
        if (this.staticChain == null) {
            this.staticChain = next instanceof InterceptingMessageProcessor ? new SimpleMessageProcessorChain(next) : next;
        }
        super.setListener(next);
    }

    private String resetAndUpdatePipeline(String id, List<MessageProcessor> preMessageProcessors, List<MessageProcessor> postMessageProcessors) throws MuleException {
        this.checkPipelineId(id);
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this.flow);
        builder.chain(preMessageProcessors);
        builder.chain(this.staticChain);
        builder.chain(postMessageProcessors);
        MessageProcessorChain newChain = builder.build();
        AbstractMessageProcessorChain preChainOld = this.preChain;
        AbstractMessageProcessorChain postChainOld = this.postChain;
        this.preChain = new SimpleMessageProcessorChain(preMessageProcessors);
        this.postChain = new SimpleMessageProcessorChain(postMessageProcessors);
        this.initDynamicChains();
        super.setListener(newChain);
        this.disposeDynamicChains(preChainOld, postChainOld);
        return this.getPipelineId();
    }

    private synchronized void checkPipelineId(String id) throws DynamicPipelineException {
        if (this.pipelineId != null) {
            if (!StringUtils.equals((String)this.pipelineId, (String)id)) {
                throw new DynamicPipelineException(CoreMessages.createStaticMessage("Invalid Dynamic Pipeline ID"));
            }
        } else {
            this.pipelineId = id != null ? id : UUID.getUUID();
        }
    }

    private synchronized String getPipelineId() {
        return this.pipelineId;
    }

    private String resetPipeline(String id) throws MuleException {
        ArrayList<MessageProcessor> emptyList = new ArrayList<MessageProcessor>();
        return this.resetAndUpdatePipeline(id, emptyList, emptyList);
    }

    private void initDynamicChains() throws MuleException {
        for (Lifecycle chain : new Lifecycle[]{this.preChain, this.postChain}) {
            if (chain == null) continue;
            this.flow.injectFlowConstructMuleContext(chain);
            this.flow.injectExceptionHandler(chain);
            this.flow.initialiseIfInitialisable(chain);
            this.flow.startIfStartable(chain);
        }
    }

    private void disposeDynamicChains(Lifecycle ... chains) throws MuleException {
        for (Lifecycle chain : chains) {
            if (chain == null) continue;
            chain.stop();
            chain.dispose();
        }
    }

    @Override
    public DynamicPipelineBuilder dynamicPipeline(String id) throws DynamicPipelineException {
        this.checkPipelineId(id);
        return new Builder();
    }

    private class Builder
    implements DynamicPipelineBuilder {
        private List<MessageProcessor> preList = new ArrayList<MessageProcessor>();
        private List<MessageProcessor> postList = new ArrayList<MessageProcessor>();

        private Builder() {
        }

        @Override
        public DynamicPipelineBuilder injectBefore(MessageProcessor ... messageProcessors) {
            Collections.addAll(this.preList, messageProcessors);
            return this;
        }

        @Override
        public DynamicPipelineBuilder injectBefore(List<MessageProcessor> messageProcessors) {
            return this.injectBefore(messageProcessors.toArray(new MessageProcessor[messageProcessors.size()]));
        }

        @Override
        public DynamicPipelineBuilder injectAfter(MessageProcessor ... messageProcessors) {
            Collections.addAll(this.postList, messageProcessors);
            return this;
        }

        @Override
        public DynamicPipelineBuilder injectAfter(List<MessageProcessor> messageProcessors) {
            return this.injectAfter(messageProcessors.toArray(new MessageProcessor[messageProcessors.size()]));
        }

        @Override
        public String resetAndUpdate() throws MuleException {
            return this.pipeline().resetAndUpdatePipeline(this.pipeline().getPipelineId(), this.preList, this.postList);
        }

        @Override
        public String reset() throws MuleException {
            return this.pipeline().resetPipeline(this.pipeline().getPipelineId());
        }

        private DynamicPipelineMessageProcessor pipeline() {
            return DynamicPipelineMessageProcessor.this;
        }
    }
}

