/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.security.AbstractJCEEncryptionStrategy;
import org.mule.security.SecretKeyFactory;
import org.mule.util.StringMessageUtils;

@Deprecated
public class SecretKeyEncryptionStrategy
extends AbstractJCEEncryptionStrategy {
    public static final String DEFAULT_ALGORITHM = "Blowfish";
    private byte[] key;
    private SecretKeyFactory keyFactory;

    public SecretKeyEncryptionStrategy() {
        this.algorithm = DEFAULT_ALGORITHM;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.key == null) {
            if (this.keyFactory == null) {
                throw new InitialisationException(CoreMessages.objectIsNull("Key / KeyFactory"), (Initialisable)this);
            }
            try {
                this.key = this.keyFactory.getKey();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        super.initialise();
    }

    @Override
    protected void createAndInitCiphers() throws GeneralSecurityException {
        this.encryptCipher = Cipher.getInstance(this.getAlgorithm());
        this.decryptCipher = Cipher.getInstance(this.getAlgorithm());
        AlgorithmParameterSpec paramSpec = this.createAlgorithmParameterSpec();
        if (paramSpec != null) {
            this.encryptCipher.init(1, (Key)((SecretKeySpec)this.keySpec), paramSpec);
            this.decryptCipher.init(2, (Key)((SecretKeySpec)this.keySpec), paramSpec);
        } else {
            this.encryptCipher.init(1, (SecretKeySpec)this.keySpec);
            this.decryptCipher.init(2, (SecretKeySpec)this.keySpec);
        }
    }

    @Override
    protected KeySpec createKeySpec() {
        return new SecretKeySpec(this.key, this.algorithm);
    }

    @Override
    protected AlgorithmParameterSpec createAlgorithmParameterSpec() {
        return null;
    }

    public void setKey(byte[] rawKey) {
        this.key = rawKey;
    }

    public void setKey(String rawKey) {
        this.key = StringMessageUtils.getBytes(rawKey);
    }

    public SecretKeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    public void setKeyFactory(SecretKeyFactory keyFactory) {
        this.keyFactory = keyFactory;
    }

    @Override
    protected SecretKey getSecretKey() throws GeneralSecurityException {
        return KeyGenerator.getInstance(this.algorithm).generateKey();
    }
}

