/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.PartitionableExpirableObjectStore;
import org.mule.util.store.AbstractPartitionedObjectStore;

public class PartitionedInMemoryObjectStore<T extends Serializable>
extends AbstractPartitionedObjectStore<T>
implements PartitionableExpirableObjectStore<T> {
    private ConcurrentMap<String, ConcurrentMap<Serializable, T>> partitions = new ConcurrentHashMap<String, ConcurrentMap<Serializable, T>>();
    private ConcurrentMap<String, ConcurrentLinkedQueue<ExpiryEntry>> expiryInfoPartition = new ConcurrentHashMap<String, ConcurrentLinkedQueue<ExpiryEntry>>();

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean contains(Serializable key, String partitionName) throws ObjectStoreException {
        if (this.partitions.containsKey(partitionName)) {
            return ((ConcurrentMap)this.partitions.get(partitionName)).containsKey(key);
        }
        return false;
    }

    @Override
    public void store(Serializable key, T value, String partitionName) throws ObjectStoreException {
        Serializable oldValue = (Serializable)this.getPartition(partitionName).putIfAbsent(key, value);
        if (oldValue != null) {
            throw new ObjectAlreadyExistsException();
        }
        this.getExpiryInfoPartition(partitionName).add(new ExpiryEntry(this.getCurrentNanoTime(), key));
    }

    @Override
    public T retrieve(Serializable key, String partitionName) throws ObjectStoreException {
        Serializable value = (Serializable)this.getPartition(partitionName).get(key);
        if (value == null) {
            throw new ObjectDoesNotExistException();
        }
        return (T)value;
    }

    @Override
    public T remove(Serializable key, String partitionName) throws ObjectStoreException {
        Serializable removedValue = (Serializable)this.getPartition(partitionName).remove(key);
        if (removedValue == null) {
            throw new ObjectDoesNotExistException();
        }
        Iterator<ExpiryEntry> iterator = this.getExpiryInfoPartition(partitionName).iterator();
        while (iterator.hasNext()) {
            ExpiryEntry entry = iterator.next();
            if (!key.equals(entry.getKey())) continue;
            iterator.remove();
            break;
        }
        return (T)removedValue;
    }

    @Override
    public List<Serializable> allKeys(String partitionName) throws ObjectStoreException {
        return new ArrayList<Serializable>(this.getPartition(partitionName).keySet());
    }

    @Override
    public void clear(String partitionName) throws ObjectStoreException {
        this.getPartition(partitionName).clear();
    }

    @Override
    public List<String> allPartitions() throws ObjectStoreException {
        return new ArrayList<String>(this.partitions.keySet());
    }

    private ConcurrentMap<Serializable, T> getPartition(String partitionName) {
        ConcurrentMap previous;
        ConcurrentMap partition = (ConcurrentHashMap)this.partitions.get(partitionName);
        if (partition == null && (previous = (ConcurrentMap)this.partitions.putIfAbsent(partitionName, partition = new ConcurrentHashMap())) != null) {
            partition = previous;
        }
        return partition;
    }

    private ConcurrentLinkedQueue<ExpiryEntry> getExpiryInfoPartition(String partitionName) {
        ConcurrentLinkedQueue previous;
        ConcurrentLinkedQueue partition = (ConcurrentLinkedQueue)this.expiryInfoPartition.get(partitionName);
        if (partition == null && (previous = this.expiryInfoPartition.putIfAbsent(partitionName, partition = new ConcurrentLinkedQueue())) != null) {
            partition = previous;
        }
        return partition;
    }

    @Override
    public void open(String partitionName) throws ObjectStoreException {
    }

    @Override
    public void close(String partitionName) throws ObjectStoreException {
    }

    @Override
    public void expire(int entryTTL, int maxEntries) throws ObjectStoreException {
        this.expire(entryTTL, maxEntries, "DEFAULT_PARTITION");
    }

    @Override
    public void expire(int entryTTL, int maxEntries, String partitionName) throws ObjectStoreException {
        ExpiryEntry oldestEntry;
        long now = this.getCurrentNanoTime();
        int expiredEntries = 0;
        ConcurrentLinkedQueue<ExpiryEntry> store = this.getExpiryInfoPartition(partitionName);
        ConcurrentMap<Serializable, T> partition = this.getPartition(partitionName);
        this.trimToMaxSize(store, maxEntries, partition);
        if (entryTTL == 0) {
            return;
        }
        while ((oldestEntry = store.peek()) != null && TimeUnit.NANOSECONDS.toMillis(now - oldestEntry.getTime()) >= (long)entryTTL) {
            oldestEntry = (ExpiryEntry)store.remove();
            partition.remove(oldestEntry.getKey());
            ++expiredEntries;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Expired " + expiredEntries + " old entries"));
        }
    }

    private void trimToMaxSize(ConcurrentLinkedQueue<ExpiryEntry> store, int maxEntries, ConcurrentMap<Serializable, T> partition) {
        if (maxEntries == 0) {
            return;
        }
        int currentSize = store.size();
        int excess = currentSize - maxEntries;
        if (excess > 0) {
            while (currentSize > maxEntries) {
                ExpiryEntry toRemove = (ExpiryEntry)store.remove();
                partition.remove(toRemove.getKey());
                --currentSize;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + excess + " excess entries"));
            }
        }
    }

    @Override
    public void disposePartition(String partitionName) throws ObjectStoreException {
        ConcurrentLinkedQueue entries;
        Map partition = (Map)this.partitions.remove(partitionName);
        if (partition != null) {
            partition.clear();
        }
        if ((entries = (ConcurrentLinkedQueue)this.expiryInfoPartition.remove(partitionName)) != null) {
            entries.clear();
        }
    }

    protected long getCurrentNanoTime() {
        return System.nanoTime();
    }

    private static class ExpiryEntry {
        private final long time;
        private final Serializable key;

        public ExpiryEntry(long time, Serializable key) {
            this.time = time;
            this.key = key;
        }

        public long getTime() {
            return this.time;
        }

        public Serializable getKey() {
            return this.key;
        }
    }
}

