/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpConnector;
import org.mule.transport.sftp.SftpFileArchiveInputStream;
import org.mule.transport.sftp.SftpInputStream;
import org.mule.transport.sftp.SftpUtil;
import org.mule.transport.sftp.notification.SftpNotifier;
import org.mule.util.FileUtils;

public class SftpReceiverRequesterUtil {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private final SftpConnector connector;
    private final ImmutableEndpoint endpoint;
    private final FilenameFilter filenameFilter;
    private final SftpUtil sftpUtil;

    public SftpReceiverRequesterUtil(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (SftpConnector)endpoint.getConnector();
        this.sftpUtil = this.createSftpUtil(endpoint);
        this.filenameFilter = endpoint.getFilter() instanceof FilenameFilter ? (FilenameFilter)endpoint.getFilter() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableFiles(boolean onlyGetTheFirstOne) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Checking files at endpoint " + this.endpoint.getEndpointURI()));
        }
        SftpClient client = null;
        try {
            client = this.connector.createSftpClient(this.endpoint);
            long fileAge = this.connector.getFileAge();
            boolean checkFileAge = this.connector.getCheckFileAge();
            if (this.endpoint.getProperty((Object)"fileAge") != null) {
                checkFileAge = true;
                fileAge = Long.valueOf((String)this.endpoint.getProperty((Object)"fileAge"));
            }
            this.logger.debug((Object)("fileAge : " + fileAge));
            List<String> files = Arrays.asList(client.listFiles());
            long sizeCheckDelayMs = this.sftpUtil.getSizeCheckWaitTime();
            if (sizeCheckDelayMs > 0L) {
                files = this.getStableFiles(files, client, sizeCheckDelayMs);
            }
            ArrayList<String> completedFiles = new ArrayList<String>(files.size());
            for (String file : files) {
                if (this.filenameFilter != null && !this.filenameFilter.accept(null, file)) continue;
                if (checkFileAge) {
                    if (!this.isOldFile(file, client, fileAge)) continue;
                    completedFiles.add(file);
                    if (!onlyGetTheFirstOne) continue;
                    break;
                }
                completedFiles.add(file);
                if (!onlyGetTheFirstOne) continue;
                break;
            }
            String[] stringArray = completedFiles.toArray(new String[completedFiles.size()]);
            return stringArray;
        }
        finally {
            if (client != null) {
                this.connector.releaseClient(this.endpoint, client);
            }
        }
    }

    void checkSFTPConnection() throws Exception {
        SftpClient client = null;
        try {
            client = this.connector.createSftpClient(this.endpoint);
        }
        finally {
            this.connector.releaseClient(this.endpoint, client);
        }
    }

    public InputStream retrieveFile(String fileName, SftpNotifier notifier) throws Exception {
        InputStream fileInputStream;
        SftpClient client = this.connector.createSftpClient(this.endpoint, notifier);
        String tmpSendingDir = this.sftpUtil.getTempDirInbound();
        if (tmpSendingDir != null) {
            boolean addUniqueSuffix = this.sftpUtil.isUseTempFileTimestampSuffix();
            client.createSftpDirIfNotExists(this.endpoint, tmpSendingDir);
            String tmpSendingFileName = tmpSendingDir + "/" + fileName;
            if (addUniqueSuffix) {
                tmpSendingFileName = this.sftpUtil.createUniqueSuffix(tmpSendingFileName);
            }
            String fullTmpSendingPath = this.endpoint.getEndpointURI().getPath() + "/" + tmpSendingFileName;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Move " + fileName + " to " + fullTmpSendingPath));
            }
            client.rename(fileName, fullTmpSendingPath);
            fileName = tmpSendingFileName;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Move done");
            }
        }
        String archive = this.sftpUtil.getArchiveDir();
        try {
            fileInputStream = client.retrieveFile(fileName);
        }
        catch (IOException e) {
            this.connector.releaseClient(this.endpoint, client);
            throw e;
        }
        if (!"".equals(archive)) {
            String archiveTmpReceivingDir = this.sftpUtil.getArchiveTempReceivingDir();
            String archiveTmpSendingDir = this.sftpUtil.getArchiveTempSendingDir();
            SftpInputStream is = new SftpInputStream(client, fileInputStream, fileName, this.determineAutoDelete(), this.endpoint);
            int idx = fileName.lastIndexOf(47);
            String fileNamePart = fileName.substring(idx + 1);
            File archiveFile = FileUtils.newFile((String)archive, (String)fileNamePart);
            if ("".equals(archiveTmpReceivingDir) || "".equals(archiveTmpSendingDir)) {
                return this.archiveFile(is, archiveFile);
            }
            return this.archiveFileUsingTempDirs(archive, archiveTmpReceivingDir, archiveTmpSendingDir, is, fileNamePart, archiveFile);
        }
        return new SftpInputStream(client, fileInputStream, fileName, this.determineAutoDelete(), this.endpoint);
    }

    private boolean determineAutoDelete() {
        String autoDeleteProperty = (String)this.endpoint.getProperty((Object)"autoDelete");
        boolean autoDelete = autoDeleteProperty == null ? this.connector.isAutoDelete() : Boolean.valueOf(autoDeleteProperty).booleanValue();
        return autoDelete;
    }

    private InputStream archiveFileUsingTempDirs(String archive, String archiveTmpReceivingDir, String archiveTmpSendingDir, SftpInputStream is, String fileNamePart, File archiveFile) throws IOException {
        File archiveTmpReceivingFolder = FileUtils.newFile((String)(archive + '/' + archiveTmpReceivingDir));
        File archiveTmpReceivingFile = FileUtils.newFile((String)(archive + '/' + archiveTmpReceivingDir), (String)fileNamePart);
        if (!archiveTmpReceivingFolder.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Creates " + archiveTmpReceivingFolder.getAbsolutePath()));
            }
            if (!archiveTmpReceivingFolder.mkdirs()) {
                throw new IOException("Failed to create archive-tmp-receiving-folder: " + archiveTmpReceivingFolder);
            }
        }
        File archiveTmpSendingFolder = FileUtils.newFile((String)(archive + '/' + archiveTmpSendingDir));
        File archiveTmpSendingFile = FileUtils.newFile((String)(archive + '/' + archiveTmpSendingDir), (String)fileNamePart);
        if (!archiveTmpSendingFolder.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Creates " + archiveTmpSendingFolder.getAbsolutePath()));
            }
            if (!archiveTmpSendingFolder.mkdirs()) {
                throw new IOException("Failed to create archive-tmp-sending-folder: " + archiveTmpSendingFolder);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Copy SftpInputStream to archiveTmpReceivingFile... " + archiveTmpReceivingFile.getAbsolutePath()));
        }
        this.sftpUtil.copyStreamToFile(is, archiveTmpReceivingFile);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Move archiveTmpReceivingFile (" + archiveTmpReceivingFile + ") to archiveTmpSendingFile (" + archiveTmpSendingFile + ")..."));
        }
        FileUtils.moveFile((File)archiveTmpReceivingFile, (File)archiveTmpSendingFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Return SftpFileArchiveInputStream for archiveTmpSendingFile (" + archiveTmpSendingFile + ")..."));
        }
        return new SftpFileArchiveInputStream(archiveTmpSendingFile, archiveFile, is);
    }

    private InputStream archiveFile(SftpInputStream is, File archiveFile) throws IOException {
        File archiveFolder = FileUtils.newFile((String)archiveFile.getParentFile().getPath());
        if (!archiveFolder.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Creates " + archiveFolder.getAbsolutePath()));
            }
            if (!archiveFolder.mkdirs()) {
                throw new IOException("Failed to create archive-folder: " + archiveFolder);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Copy SftpInputStream to archiveFile... " + archiveFile.getAbsolutePath()));
        }
        this.sftpUtil.copyStreamToFile(is, archiveFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"*** Return SftpFileArchiveInputStream for archiveFile...");
        }
        return new SftpFileArchiveInputStream(archiveFile, is);
    }

    List<String> getStableFiles(List<String> fileNames, SftpClient client, long sizeCheckDelayMs) throws InterruptedException {
        ArrayList<String> stableFiles = new ArrayList<String>(fileNames.size());
        Map<String, Long> fileSizesBeforeDelay = this.getFileTimeStamps(fileNames, client);
        Thread.sleep(sizeCheckDelayMs);
        Map<String, Long> fileSizesAfterDelay = this.getFileTimeStamps(fileNames, client);
        for (Map.Entry<String, Long> sizeEntry : fileSizesBeforeDelay.entrySet()) {
            Long sizeAfterDelay;
            Long sizeBeforeDelay = sizeEntry.getValue();
            if (!sizeBeforeDelay.equals(sizeAfterDelay = fileSizesAfterDelay.get(sizeEntry.getKey()))) continue;
            stableFiles.add(sizeEntry.getKey());
        }
        return stableFiles;
    }

    private Map<String, Long> getFileTimeStamps(List<String> fileNames, SftpClient client) {
        HashMap<String, Long> sizes = new HashMap<String, Long>();
        for (String fileName : fileNames) {
            try {
                sizes.put(fileName, client.getSize(fileName));
            }
            catch (IOException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)String.format("Cannot get the size of file '%s'", fileName));
            }
        }
        return sizes;
    }

    boolean isOldFile(String fileName, SftpClient client, long fileAge) throws IOException {
        try {
            long lastModifiedTime = client.getLastModifiedTime(fileName);
            long now = System.currentTimeMillis();
            long diff = now - lastModifiedTime;
            if (diff < fileAge) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + fileName + ". The file must be " + (fileAge - diff) + "ms older, was " + diff));
                }
                return false;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The file " + fileName + " has aged enough. Was " + diff));
            }
            return true;
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Cannot check if age of file '%s' is old enough", fileName));
            }
            return false;
        }
    }

    protected SftpUtil createSftpUtil(ImmutableEndpoint endpoint) {
        return new SftpUtil(endpoint);
    }
}

