/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ftp;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.retry.RetryContext;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.ftp.FtpConnector;

public class FtpMessageDispatcher
extends AbstractMessageDispatcher {
    protected final FtpConnector connector;

    public FtpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (FtpConnector)endpoint.getConnector();
    }

    protected void doDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(MuleEvent event) throws Exception {
        Object data = event.getMessage().getPayload();
        try (OutputStream out = this.connector.getOutputStream(this.getEndpoint(), event);){
            if (data instanceof InputStream) {
                InputStream is = (InputStream)data;
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
            } else if (data instanceof OutputHandler) {
                ((OutputHandler)data).write(event, out);
            } else {
                byte[] dataBytes = data instanceof byte[] ? (byte[])data : data.toString().getBytes(event.getEncoding());
                IOUtils.write((byte[])dataBytes, (OutputStream)out);
            }
        }
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.getEndpoint().getMuleContext());
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        try {
            EndpointURI uri = this.endpoint.getEndpointURI();
            FTPClient client = this.connector.getFtp(this.endpoint);
            this.connector.destroyFtp(this.endpoint, client);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        FTPClient client = null;
        try {
            client = this.connector.createFtpClient(this.endpoint);
            client.sendNoOp();
            client.logout();
            client.disconnect();
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed((Throwable)ex);
        }
        finally {
            block13: {
                try {
                    if (client != null) {
                        this.connector.releaseFtp(this.endpoint, client);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block13;
                    this.logger.debug((Object)("Failed to release ftp client " + client), (Throwable)e);
                }
            }
        }
        return retryContext;
    }
}

