/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.URLName;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.AbstractConnector;
import org.mule.transport.email.DefaultAuthenticator;
import org.mule.transport.email.SessionDetails;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public abstract class AbstractMailConnector
extends AbstractConnector {
    public static final String ATTACHMENT_HEADERS_PROPERTY_POSTFIX = "Headers";
    public static final String MAILBOX = "INBOX";
    private Map<ImmutableEndpoint, SessionDetails> sessions = new HashMap<ImmutableEndpoint, SessionDetails>();
    private String mailboxFolder;
    private int defaultPort;
    private Authenticator authenticator = null;

    public AbstractMailConnector(int defaultPort, String mailboxFolder, MuleContext context) {
        super(context);
        this.defaultPort = defaultPort;
        this.mailboxFolder = mailboxFolder;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public String getMailboxFolder() {
        return this.mailboxFolder;
    }

    public void setMailboxFolder(String mailboxFolder) {
        this.mailboxFolder = mailboxFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionDetails getSessionDetails(ImmutableEndpoint endpoint) throws UnsupportedEncodingException {
        Map<ImmutableEndpoint, SessionDetails> map = this.sessions;
        synchronized (map) {
            SessionDetails sessionDetails = this.sessions.get(endpoint);
            if (null == sessionDetails) {
                sessionDetails = this.newSession(endpoint);
                this.sessions.put(endpoint, sessionDetails);
            }
            return sessionDetails;
        }
    }

    public URLName urlFromEndpoint(ImmutableEndpoint endpoint) throws UnsupportedEncodingException {
        String inbox = endpoint.getEndpointURI().getPath();
        inbox = inbox.length() == 0 ? this.getMailboxFolder() : inbox.substring(1);
        EndpointURI uri = endpoint.getEndpointURI();
        String user = uri.getUser();
        String pass = uri.getPassword();
        return new URLName(uri.getScheme(), uri.getHost(), uri.getPort(), inbox, user, pass);
    }

    protected String getBaseProtocol() {
        return this.getProtocol();
    }

    protected void extendPropertiesForSession(Properties global, Properties local, URLName url) {
        int port = url.getPort();
        if (port == -1) {
            port = this.getDefaultPort();
        }
        local.setProperty("mail." + this.getBaseProtocol() + ".socketFactory.port", Integer.toString(port));
        if (StringUtils.isNotBlank((String)url.getPassword())) {
            local.setProperty("mail." + this.getBaseProtocol() + ".auth", "true");
            if (this.getAuthenticator() == null) {
                this.setAuthenticator(new DefaultAuthenticator(url.getUsername(), url.getPassword()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No Authenticator set on connector: " + this.getName() + "; using default."));
                }
            }
        } else {
            local.setProperty("mail." + this.getBaseProtocol() + ".auth", "false");
        }
        if (StringUtils.isNotBlank((String)url.getHost())) {
            local.setProperty("mail." + this.getBaseProtocol() + ".host", url.getHost());
        }
        local.setProperty("mail." + this.getBaseProtocol() + ".rsetbeforequit", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionDetails newSession(ImmutableEndpoint endpoint) throws UnsupportedEncodingException {
        Session session;
        URLName url = this.urlFromEndpoint(endpoint);
        Properties global = System.getProperties();
        Properties local = new Properties();
        PropertiesUtils.getPropertiesWithPrefix((Map)endpoint.getProperties(), (String)"mail.", (Map)local);
        Properties properties = global;
        synchronized (properties) {
            this.extendPropertiesForSession(global, local, url);
            session = Session.getInstance((Properties)local, (Authenticator)this.getAuthenticator());
        }
        if (this.logger.isDebugEnabled()) {
            local.setProperty("mail.debug", "true");
            this.dumpProperties("MuleSession local properties", local, true);
            this.dumpProperties("System global properties", global, true);
            this.logger.debug((Object)("Creating mail session: host = " + url.getHost() + ", port = " + url.getPort() + ", user = " + url.getUsername() + ", pass = " + url.getPassword()));
        }
        return new SessionDetails(session, url);
    }

    protected void dumpProperties(String title, Properties properties, boolean filter) {
        int skipped = 0;
        this.logger.debug((Object)(title + " ============="));
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!filter || key.startsWith("mule.") || key.startsWith("mail.") || key.startsWith("javax.")) {
                String value = properties.getProperty(key);
                this.logger.debug((Object)(key + ": " + value));
                continue;
            }
            ++skipped;
        }
        if (filter) {
            this.logger.debug((Object)("skipped " + skipped));
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }
}

