/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.ExceptionHelper;
import org.mule.execution.EndPhaseTemplate;
import org.mule.execution.RequestResponseFlowProcessingPhaseTemplate;
import org.mule.execution.ResponseDispatchException;
import org.mule.execution.ThrottlingPhaseTemplate;
import org.mule.module.http.internal.listener.HttpMessageProcessorTemplate;
import org.mule.module.http.internal.listener.HttpThrottlingHeadersMapBuilder;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractTransportMessageProcessTemplate;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMessageReceiver;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.ArrayUtils;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.Latch;

public class HttpMessageProcessTemplate
extends AbstractTransportMessageProcessTemplate<HttpMessageReceiver, HttpConnector>
implements RequestResponseFlowProcessingPhaseTemplate,
ThrottlingPhaseTemplate,
EndPhaseTemplate {
    public static final int MESSAGE_DISCARD_STATUS_CODE = HttpMessageProcessorTemplate.MESSAGE_DISCARD_STATUS_CODE;
    public static final String MESSAGE_THROTTLED_REASON_PHRASE = "API calls exceeded";
    public static final String X_RATE_LIMIT_LIMIT_HEADER = "X-RateLimit-Limit";
    public static final String X_RATE_LIMIT_REMAINING_HEADER = "X-RateLimit-Remaining";
    public static final String X_RATE_LIMIT_RESET_HEADER = "X-RateLimit-Reset";
    private final HttpServerConnection httpServerConnection;
    private HttpRequest request;
    private boolean badRequest;
    private Latch messageProcessedLatch = new Latch();
    private RequestLine requestLine;
    private boolean failureResponseSentToClient;
    private HttpThrottlingHeadersMapBuilder httpThrottlingHeadersMapBuilder;

    public HttpMessageProcessTemplate(HttpMessageReceiver messageReceiver, HttpServerConnection httpServerConnection) {
        super((AbstractMessageReceiver)messageReceiver);
        this.httpServerConnection = httpServerConnection;
        this.httpThrottlingHeadersMapBuilder = new HttpThrottlingHeadersMapBuilder();
    }

    public void sendResponseToClient(MuleEvent responseMuleEvent) throws MuleException {
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Sending http response");
            }
            MuleMessage returnMessage = responseMuleEvent == null ? null : responseMuleEvent.getMessage();
            Object tempResponse = returnMessage != null ? returnMessage.getPayload() : NullPayload.getInstance();
            HttpResponse response = tempResponse instanceof HttpResponse ? (HttpResponse)tempResponse : this.transformResponse(returnMessage);
            response.setupKeepAliveFromRequestVersion(this.request.getRequestLine().getHttpVersion());
            HttpConnector httpConnector = (HttpConnector)((HttpMessageReceiver)this.getMessageReceiver()).getEndpoint().getConnector();
            response.disableKeepAlive(!httpConnector.isKeepAlive());
            Header connectionHeader = this.request.getFirstHeader("Connection");
            boolean endpointOverride = ((HttpMessageReceiver)this.getMessageReceiver()).getEndpoint().getProperty((Object)"keepAlive") != null;
            boolean endpointKeepAliveValue = this.getEndpointKeepAliveValue((ImmutableEndpoint)((HttpMessageReceiver)this.getMessageReceiver()).getEndpoint());
            if (endpointOverride) {
                response.disableKeepAlive(!endpointKeepAliveValue);
            } else {
                response.disableKeepAlive(!httpConnector.isKeepAlive());
            }
            if (connectionHeader != null) {
                String value = connectionHeader.getValue();
                if ("keep-alive".equalsIgnoreCase(value) && endpointKeepAliveValue) {
                    response.setKeepAlive(true);
                    if (response.getHttpVersion().equals(HttpVersion.HTTP_1_0)) {
                        connectionHeader = new Header("Connection", "Keep-Alive");
                        response.setHeader(connectionHeader);
                    }
                } else if ("close".equalsIgnoreCase(value) || !endpointKeepAliveValue) {
                    response.setKeepAlive(false);
                }
            } else if (this.request.getRequestLine().getHttpVersion().equals(HttpVersion.HTTP_1_1)) {
                response.setKeepAlive(endpointKeepAliveValue);
            }
            try {
                this.httpServerConnection.writeResponse(response, this.getThrottlingHeaders());
            }
            catch (Exception e) {
                throw new ResponseDispatchException(responseMuleEvent, (Throwable)e);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"HTTP response sent successfully");
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Exception while sending http response");
                this.logger.debug((Object)e);
            }
            throw new MessagingException(responseMuleEvent, (Throwable)e);
        }
    }

    public void sendFailureResponseToClient(MessagingException messagingException) throws MuleException {
        MuleEvent response = messagingException.getEvent();
        MessagingException e = this.getExceptionForCreatingFailureResponse(messagingException, response);
        String temp = ExceptionHelper.getErrorMapping((String)this.getInboundEndpoint().getConnector().getProtocol(), messagingException.getClass(), (MuleContext)this.getMuleContext());
        int httpStatus = Integer.valueOf(temp);
        try {
            this.sendFailureResponseToClient(e, httpStatus);
        }
        catch (IOException ioException) {
            throw new DefaultMuleException((Throwable)ioException);
        }
        this.failureResponseSentToClient = true;
    }

    private MessagingException getExceptionForCreatingFailureResponse(MessagingException messagingException, MuleEvent response) {
        MessagingException e = messagingException;
        if (response != null && response.getMessage().getExceptionPayload() != null && response.getMessage().getExceptionPayload().getException() instanceof MessagingException) {
            e = (MessagingException)response.getMessage().getExceptionPayload().getException();
        }
        return e;
    }

    public void afterFailureProcessingFlow(MuleException exception) throws MuleException {
        block4: {
            Throwable error = exception;
            if (error instanceof DefaultMuleException && error.getCause() instanceof CreateException && error.getCause().getCause() != null) {
                error = error.getCause().getCause();
            }
            if (!this.failureResponseSentToClient) {
                String temp = ExceptionHelper.getErrorMapping((String)((HttpConnector)this.getConnector()).getProtocol(), error.getClass(), (MuleContext)this.getMuleContext());
                int httpStatus = Integer.valueOf(temp);
                try {
                    this.sendFailureResponseToClient(httpStatus, error.getMessage());
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Exception sending http response after error: " + e.getMessage()));
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)e);
                }
            }
        }
    }

    public MuleEvent beforeRouteEvent(MuleEvent muleEvent) throws MuleException {
        try {
            this.sendExpect100(this.request);
            return muleEvent;
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private void sendExpect100(HttpRequest request) throws MuleException, IOException {
        String expectHeaderValue;
        Header expectHeader;
        RequestLine requestLine = request.getRequestLine();
        HttpVersion requestVersion = requestLine.getHttpVersion();
        if (HttpVersion.HTTP_1_1.equals(requestVersion) && (expectHeader = request.getFirstHeader("Expect")) != null && "100-continue".equals(expectHeaderValue = expectHeader.getValue())) {
            HttpResponse expected = new HttpResponse();
            expected.setStatusLine(requestLine.getHttpVersion(), 100);
            expected.setKeepAlive(true);
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)expected, this.getMuleContext()), this.getInboundEndpoint(), this.getFlowConstruct());
            RequestContext.setEvent((MuleEvent)event);
            this.httpServerConnection.writeResponse(expected);
        }
    }

    private boolean getEndpointKeepAliveValue(ImmutableEndpoint ep) {
        String value = (String)ep.getProperty((Object)"keepAlive");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }

    protected HttpResponse transformResponse(Object response) throws MuleException {
        Object message = response instanceof MuleMessage ? (MuleMessage)response : new DefaultMuleMessage(response, ((HttpMessageReceiver)this.getMessageReceiver()).getEndpoint().getMuleContext());
        message.applyTransformers(null, ((HttpMessageReceiver)this.getMessageReceiver()).getResponseTransportTransformers(), HttpResponse.class);
        return (HttpResponse)message.getPayload();
    }

    protected MuleMessage createMessageFromSource(Object message) throws MuleException {
        MuleMessage muleMessage = super.createMessageFromSource(message);
        String path = (String)muleMessage.getInboundProperty("http.request");
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        muleMessage.setProperty("http.request.path", (Object)path, PropertyScope.INBOUND);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(muleMessage.getInboundProperty("http.request"));
        }
        String contextPath = HttpConnector.normalizeUrl(this.getInboundEndpoint().getEndpointURI().getPath());
        muleMessage.setProperty("http.context.path", (Object)contextPath, PropertyScope.INBOUND);
        muleMessage.setProperty("http.context.uri", (Object)this.getInboundEndpoint().getEndpointURI().getAddress(), PropertyScope.INBOUND);
        muleMessage.setProperty("http.relative.path", (Object)this.processRelativePath(contextPath, path), PropertyScope.INBOUND);
        this.processRemoteAddresses(muleMessage);
        return muleMessage;
    }

    protected void processRemoteAddresses(MuleMessage muleMessage) {
        String xForwardedFor = (String)muleMessage.getInboundProperty("X-Forwarded-For");
        if (StringUtils.isEmpty((String)xForwardedFor)) {
            muleMessage.setProperty("MULE_REMOTE_CLIENT_ADDRESS", (Object)this.httpServerConnection.getRemoteClientAddress(), PropertyScope.INBOUND);
            return;
        }
        Object[] xForwardedForItems = StringUtils.splitAndTrim((String)xForwardedFor, (String)",");
        if (!ArrayUtils.isEmpty((Object[])xForwardedForItems)) {
            muleMessage.setProperty("MULE_REMOTE_CLIENT_ADDRESS", xForwardedForItems[0], PropertyScope.INBOUND);
            if (xForwardedForItems.length > 1) {
                muleMessage.setProperty("MULE_PROXY_ADDRESS", xForwardedForItems[xForwardedForItems.length - 1], PropertyScope.INBOUND);
            } else {
                muleMessage.setProperty("MULE_PROXY_ADDRESS", (Object)this.httpServerConnection.getRemoteClientAddress(), PropertyScope.INBOUND);
            }
        }
    }

    protected String processRelativePath(String contextPath, String path) {
        String relativePath = path.substring(contextPath.length());
        if (relativePath.startsWith("/")) {
            return relativePath.substring(1);
        }
        return relativePath;
    }

    public Object acquireMessage() throws MuleException {
        HttpRequest request;
        try {
            request = this.httpServerConnection.readRequest();
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        if (request == null) {
            throw new HttpMessageReceiver.EmptyRequestException();
        }
        this.request = request;
        return request;
    }

    public boolean validateMessage() {
        try {
            this.requestLine = this.httpServerConnection.getRequestLine();
            if (this.requestLine == null) {
                return false;
            }
            String method = this.requestLine.getMethod();
            if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST") || method.equals("OPTIONS") || method.equals("PUT") || method.equals("DELETE") || method.equals("TRACE") || method.equals("CONNECT") || method.equals("PATCH"))) {
                this.badRequest = true;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void discardInvalidMessage() throws MuleException {
        if (this.badRequest) {
            try {
                this.httpServerConnection.writeResponse(this.doBad(this.requestLine));
            }
            catch (IOException e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
    }

    protected HttpResponse doBad(RequestLine requestLine) throws MuleException {
        MuleMessage message = ((HttpMessageReceiver)this.getMessageReceiver()).createMuleMessage(null);
        DefaultMuleEvent event = new DefaultMuleEvent(message, this.getInboundEndpoint(), this.getFlowConstruct());
        OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
        HttpResponse response = new HttpResponse();
        response.setStatusLine(requestLine.getHttpVersion(), 400);
        response.setBody(HttpMessages.malformedSyntax().toString() + "\r\n");
        return this.transformResponse(response);
    }

    protected HttpServerConnection getHttpServerConnection() {
        return this.httpServerConnection;
    }

    public void discardMessageOnThrottlingExceeded() throws MuleException {
        try {
            this.sendFailureResponseToClient(MESSAGE_DISCARD_STATUS_CODE, MESSAGE_THROTTLED_REASON_PHRASE);
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    public void setThrottlingPolicyStatistics(long remainingRequestInCurrentPeriod, long maximumRequestAllowedPerPeriod, long timeUntilNextPeriodInMillis) {
        this.httpThrottlingHeadersMapBuilder.setThrottlingPolicyStatistics(remainingRequestInCurrentPeriod, maximumRequestAllowedPerPeriod, timeUntilNextPeriodInMillis);
    }

    private void sendFailureResponseToClient(int httpStatus, String message) throws IOException {
        this.httpServerConnection.writeFailureResponse(httpStatus, message, this.getThrottlingHeaders());
    }

    private void sendFailureResponseToClient(MessagingException exception, int httpStatus) throws IOException, MuleException {
        MuleEvent response = exception.getEvent();
        response.getMessage().setPayload((Object)exception.getMessage());
        httpStatus = response.getMessage().getOutboundProperty("http.status") != null ? Integer.valueOf(response.getMessage().getOutboundProperty("http.status").toString()) : httpStatus;
        response.getMessage().setOutboundProperty("http.status", (Object)httpStatus);
        HttpResponse httpResponse = this.transformResponse(response.getMessage());
        this.httpServerConnection.writeResponse(httpResponse, this.getThrottlingHeaders());
    }

    private Map<String, String> getThrottlingHeaders() {
        return this.httpThrottlingHeadersMapBuilder.build();
    }

    public void messageProcessingEnded() {
        this.messageProcessedLatch.release();
    }

    public void awaitTermination() throws InterruptedException {
        this.messageProcessedLatch.await();
    }
}

