/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.net.Socket;
import java.security.cert.Certificate;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.resource.spi.work.Work;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.ConnectException;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.http.OldHttpMessageReceiver;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.StringUtils;

public class OldHttpsMessageReceiver
extends OldHttpMessageReceiver {
    public OldHttpsMessageReceiver(Connector connector, FlowConstruct flow, InboundEndpoint endpoint) throws CreateException {
        super(connector, flow, endpoint);
    }

    @Override
    protected void doConnect() throws ConnectException {
        this.checkKeyStore();
        super.doConnect();
    }

    protected void checkKeyStore() throws ConnectException {
        HttpsConnector httpsConnector = (HttpsConnector)this.connector;
        String keyStore = httpsConnector.getKeyStore();
        if (StringUtils.isBlank((String)keyStore)) {
            throw new ConnectException(CoreMessages.objectIsNull((String)"tls-key-store"), (Connectable)this);
        }
    }

    @Override
    protected Work createWork(Socket socket) throws IOException {
        return new HttpsWorker(socket);
    }

    private class HttpsWorker
    extends OldHttpMessageReceiver.HttpWorker
    implements HandshakeCompletedListener {
        private Certificate[] peerCertificateChain;
        private Certificate[] localCertificateChain;
        private final CountDownLatch latch;

        public HttpsWorker(Socket socket) throws IOException {
            super(socket);
            this.latch = new CountDownLatch(1);
            ((SSLSocket)socket).addHandshakeCompletedListener(this);
        }

        @Override
        protected void preRouteMessage(MuleMessage message) throws MessagingException {
            try {
                long timeout = ((HttpsConnector)OldHttpsMessageReceiver.this.getConnector()).getSslHandshakeTimeout();
                boolean handshakeComplete = this.latch.await(timeout, TimeUnit.MILLISECONDS);
                if (!handshakeComplete) {
                    throw new MessagingException(HttpMessages.sslHandshakeDidNotComplete(), message);
                }
            }
            catch (InterruptedException e) {
                throw new MessagingException(HttpMessages.sslHandshakeDidNotComplete(), message, (Throwable)e);
            }
            super.preRouteMessage(message);
            if (this.peerCertificateChain != null) {
                message.setOutboundProperty("PEER_CERTIFICATES", (Object)this.peerCertificateChain);
            }
            if (this.localCertificateChain != null) {
                message.setOutboundProperty("LOCAL_CERTIFICATES", (Object)this.localCertificateChain);
            }
        }

        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            try {
                this.localCertificateChain = event.getLocalCertificates();
                try {
                    this.peerCertificateChain = event.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException e) {
                    OldHttpsMessageReceiver.this.logger.debug((Object)("Cannot get peer certificate chain: " + e.getMessage()));
                }
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

