/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.rmi;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.collections.MapUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractJndiConnector;
import org.mule.transport.rmi.i18n.RmiMessages;
import org.mule.util.ArrayUtils;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;

public class RmiConnector
extends AbstractJndiConnector {
    public static final String RMI = "rmi";
    public static final int DEFAULT_RMI_muleRegistry_PORT = 1099;
    public static final String PROPERTY_RMI_SECURITY_POLICY = "securityPolicy";
    public static final String PROPERTY_RMI_SERVER_CODEBASE = "serverCodebase";
    public static final String PROPERTY_SERVER_CLASS_NAME = "serverClassName";
    public static final String PROPERTY_SERVICE_METHOD_PARAM_TYPES = "methodArgumentTypes";
    public static final String PROPERTY_SERVICE_METHOD_PARAMS_LIST = "methodArgumentsList";
    private String securityPolicy = null;
    private String serverCodebase = null;
    private String serverClassName = null;
    protected long pollingFrequency = 1000L;
    private SecurityManager securityManager = new RMISecurityManager();

    public RmiConnector(MuleContext context) {
        super(context);
    }

    protected void doInitialise() throws InitialisationException {
        if (this.securityPolicy != null) {
            System.setProperty("java.security.policy", this.securityPolicy);
        }
        if (this.securityManager != null) {
            System.setSecurityManager(this.securityManager);
        }
        this.initJndiContext();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String getProtocol() {
        return RMI;
    }

    public String getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(String path) {
        if (path != null) {
            URL url = IOUtils.getResourceAsUrl((String)path, RmiConnector.class);
            if (url == null) {
                throw new IllegalArgumentException("Error on initialization, RMI security policy does not exist");
            }
            this.securityPolicy = url.toString();
        }
    }

    public String getServerCodebase() {
        return this.serverCodebase;
    }

    public void setServerCodebase(String serverCodebase) {
        this.serverCodebase = serverCodebase;
    }

    public String getServerClassName() {
        return this.serverClassName;
    }

    public void setServerClassName(String serverClassName) {
        this.serverClassName = serverClassName;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        Object[] args = new Object[]{new Long(this.pollingFrequency)};
        return this.getServiceDescriptor().createMessageReceiver((Connector)this, flowConstruct, endpoint, args);
    }

    public Method getMethodObject(Remote remoteObject, MuleEvent event, OutboundEndpoint outboundEndpoint) throws MuleException, NoSuchMethodException, ClassNotFoundException {
        EndpointURI endpointUri = outboundEndpoint.getEndpointURI();
        String methodName = MapUtils.getString((Map)endpointUri.getParams(), (Object)"method", null);
        if (null == methodName && null == (methodName = (String)event.getMessage().removeProperty("method", PropertyScope.INVOCATION))) {
            throw new MessagingException(RmiMessages.messageParamServiceMethodNotSet(), event);
        }
        Class[] argTypes = this.getArgTypes(event.getMessage().getInvocationProperty(PROPERTY_SERVICE_METHOD_PARAM_TYPES), event);
        try {
            return remoteObject.getClass().getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException(CoreMessages.methodWithParamsNotFoundOnObject((String)methodName, (Object)ArrayUtils.toString((Object)argTypes), remoteObject.getClass()).toString());
        }
        catch (SecurityException e) {
            throw e;
        }
    }

    protected Class[] stringsToClasses(Collection strings) throws ClassNotFoundException {
        Class[] classes = new Class[strings.size()];
        int index = 0;
        Iterator string = strings.iterator();
        while (string.hasNext()) {
            classes[index++] = ClassUtils.loadClass((String)((String)string.next()), ((Object)((Object)this)).getClass());
        }
        return classes;
    }

    protected Object getRemoteRef(ImmutableEndpoint endpoint) throws IOException, NotBoundException, NamingException, InitialisationException {
        EndpointURI endpointUri = endpoint.getEndpointURI();
        String serviceName = endpointUri.getPath();
        try {
            return this.getJndiContext().lookup(serviceName);
        }
        catch (NamingException namingException) {
            try {
                serviceName = serviceName.substring(1);
                return this.getJndiContext().lookup(serviceName);
            }
            catch (NamingException namingException2) {
                int port = endpointUri.getPort();
                if (port < 1) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("RMI port not set on URI: " + endpointUri + ". Using default port: " + 1099));
                    }
                    port = 1099;
                }
                InetAddress inetAddress = InetAddress.getByName(endpointUri.getHost());
                return this.getJndiContext(inetAddress.getHostAddress() + ":" + port).lookup(serviceName);
            }
        }
    }

    public Remote getRemoteObject(ImmutableEndpoint endpoint) throws IOException, NotBoundException, NamingException, InitialisationException {
        return (Remote)this.getRemoteRef(endpoint);
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    protected Class[] getArgTypes(Object args, MuleEvent fromEvent) throws ClassNotFoundException, TransformerException {
        Class[] argTypes = null;
        argTypes = args instanceof List ? this.stringsToClasses((List)args) : (args instanceof String ? this.stringsToClasses(Arrays.asList(((String)args).split(","))) : ClassUtils.getClassTypes((Object)fromEvent.getMessage().getPayload()));
        return argTypes;
    }
}

