/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.mule.module.db.internal.domain.connection.ConnectionFactory;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.connection.OracleTransactionalDbConnectionFactory;
import org.mule.module.db.internal.domain.database.GenericDbConfigFactory;
import org.mule.module.db.internal.domain.transaction.TransactionCoordinationDbTransactionManager;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.module.db.internal.domain.type.oracle.OracleXmlType;

public class OracleDbConfigFactory
extends GenericDbConfigFactory {
    private static final int CURSOR_TYPE_ID = -10;
    private static final String CURSOR_TYPE_NAME = "CURSOR";

    @Override
    protected List<DbType> getVendorDataTypes() {
        ArrayList<DbType> dbTypes = new ArrayList<DbType>();
        dbTypes.add(new ResolvedDbType(-10, CURSOR_TYPE_NAME));
        dbTypes.add(new OracleXmlType());
        return dbTypes;
    }

    @Override
    protected DbConnectionFactory createDbConnectionFactory(DataSource dataSource, ConnectionFactory connectionFactory, DbTypeManager dbTypeManager) {
        return new OracleTransactionalDbConnectionFactory(new TransactionCoordinationDbTransactionManager(), dbTypeManager, connectionFactory, dataSource);
    }
}

