/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackError;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.ping.packet.Ping;
import org.jivesoftware.smack.util.SyncPacketSend;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class PingManager {
    private static Map<Connection, PingManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private WeakReference<Connection> weakRefConnection;

    public static synchronized PingManager getInstanceFor(Connection connection) {
        PingManager pingManager = instances.get(connection);
        if (pingManager == null) {
            pingManager = new PingManager(connection);
        }
        return pingManager;
    }

    private PingManager(Connection connection) {
        this.weakRefConnection = new WeakReference<Connection>(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        if (sdm == null) {
            sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        }
        sdm.addFeature("urn:xmpp:ping");
        AndFilter pingPacketFilter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Ping.class), new IQTypeFilter(IQ.Type.GET)});
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Connection connection = (Connection)PingManager.this.weakRefConnection.get();
                IQ pong = IQ.createResultIQ((IQ)((Ping)packet));
                connection.sendPacket((Packet)pong);
            }
        }, (PacketFilter)pingPacketFilter);
    }

    public boolean ping(String jid, long pingTimeout) {
        Ping ping = new Ping(jid);
        Connection connection = (Connection)this.weakRefConnection.get();
        try {
            SyncPacketSend.getReply((Connection)connection, (Packet)ping);
        }
        catch (XMPPException exc) {
            return jid.equals(connection.getServiceName()) && exc.getSmackError() != SmackError.NO_RESPONSE_FROM_SERVER;
        }
        return true;
    }

    public boolean ping(String jid) {
        return this.ping(jid, SmackConfiguration.getPacketReplyTimeout());
    }

    public boolean isPingSupported(String jid) throws XMPPException {
        Connection connection = (Connection)this.weakRefConnection.get();
        DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(jid);
        return result.containsFeature("urn:xmpp:ping");
    }

    public boolean pingMyServer() {
        Connection connection = (Connection)this.weakRefConnection.get();
        return this.ping(connection.getServiceName());
    }

    static {
        Connection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                PingManager.getInstanceFor(connection);
            }
        });
    }
}

