/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.util.PropertyChecker;
import org.mule.util.StringMessageUtils;

public abstract class SplashScreen {
    public static final String RUNTIME_VERBOSE = "mule.runtime.verbose";
    protected static PropertyChecker RUNTIME_VERBOSE_PROPERTY = new PropertyChecker("mule.runtime.verbose", Boolean.TRUE.toString());
    protected static final String VALUE_FORMAT = " - %s";
    private static final String KEY_VALUE_FORMAT = " - %s = %s";
    protected List<String> header = new ArrayList<String>();
    protected List<String> body = new ArrayList<String>();
    protected List<String> footer = new ArrayList<String>();

    public final void setHeader(MuleContext context) {
        this.header.clear();
        this.doHeader(context);
    }

    public final void addBody(String line) {
        this.doBody(line);
    }

    public final void setFooter(MuleContext context) {
        this.footer.clear();
        this.doFooter(context);
    }

    public static String miniSplash(String message) {
        return StringMessageUtils.getBoilerPlate((String)message, (char)'+', (int)60);
    }

    protected void doHeader(MuleContext context) {
    }

    protected void doBody(String line) {
        this.body.add(line);
    }

    protected void doFooter(MuleContext context) {
    }

    protected void listItems(Collection<String> items, String description) {
        if (!items.isEmpty()) {
            this.doBody(description);
            for (String item : items) {
                this.doBody(String.format(VALUE_FORMAT, item));
            }
        }
    }

    protected void listItems(Map<String, String> map, String description) {
        if (!map.isEmpty()) {
            this.doBody(description);
            for (String key : map.keySet()) {
                if (key.equals("mule.session.sign.secretKey") || key.equals("mule.session.sign.cloudHub.secretKey")) {
                    this.doBody(String.format(KEY_VALUE_FORMAT, key, "*****"));
                    continue;
                }
                this.doBody(String.format(KEY_VALUE_FORMAT, key, map.get(key)));
            }
        }
    }

    public String toString() {
        ArrayList<String> boilerPlate = new ArrayList<String>(this.header);
        boilerPlate.addAll(this.body);
        boilerPlate.addAll(this.footer);
        return StringMessageUtils.getBoilerPlate(boilerPlate, (char)'*', (int)70);
    }

    protected SplashScreen() {
    }
}

