/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.builder.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class IdentityManager {
    private final Set<String> ids = new TreeSet<String>();
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));

    public boolean containsId(String id) {
        return this.ids.contains(id);
    }

    public void addId(String id) {
        if (this.ids.contains(id)) {
            throw new IllegalArgumentException("Id already defined " + id);
        }
        this.ids.add(id);
    }

    public String createId(String id) {
        if (!this.ids.contains(id = IdentityManager.toValidId(id))) {
            this.ids.add(id);
            return id;
        }
        int index = 1;
        while (this.ids.contains(id + index)) {
            ++index;
        }
        this.ids.add(id + index);
        return id + index;
    }

    public static String toValidId(String id) {
        if (KEYWORDS.contains(id)) {
            id = "_" + id;
        }
        return id.replaceAll("[\\[\\]]", "");
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

