/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.builder.impl;

import com.envoisolutions.sxc.builder.BuildException;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JVar;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JStaticImports {
    private final TreeSet<String> staticImports = new TreeSet();

    public static JStaticImports getStaticImports(JDefinedClass definedClass) {
        JDocComment docComment = JStaticImports.getDocComment(definedClass);
        if (docComment instanceof JDocCommentWrapper) {
            JDocCommentWrapper wrapper = (JDocCommentWrapper)docComment;
            return wrapper.getStaticImports();
        }
        JStaticImports staticImports = new JStaticImports();
        JDocCommentWrapper wrapper = new JDocCommentWrapper(staticImports, definedClass, docComment);
        JStaticImports.setDocComment(definedClass, wrapper);
        return staticImports;
    }

    private static JDocComment getDocComment(JDefinedClass definedClass) {
        try {
            Field jdocField = JDefinedClass.class.getDeclaredField("jdoc");
            jdocField.setAccessible(true);
            return (JDocComment)jdocField.get(definedClass);
        }
        catch (Exception e) {
            throw new BuildException("Unable to hack into JDefinedClass to add staic imports");
        }
    }

    private static void setDocComment(JDefinedClass definedClass, JDocComment value) {
        try {
            Field jdocField = JDefinedClass.class.getDeclaredField("jdoc");
            jdocField.setAccessible(true);
            jdocField.set(definedClass, value);
        }
        catch (Exception e) {
            throw new BuildException("Unable to hack into JDefinedClass to add staic imports");
        }
    }

    public void addStaticImport(String staticImport) {
        this.staticImports.add(staticImport);
    }

    public TreeSet<String> getStaticImports() {
        return this.staticImports;
    }

    public void generate(JFormatter f) {
        for (String staticImport : this.staticImports) {
            f.p("import static " + staticImport + ";").nl();
        }
        if (!this.staticImports.isEmpty()) {
            f.nl();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JDocCommentWrapper
    extends JDocComment {
        private final JStaticImports staticImports;
        private final JDefinedClass definedClass;
        private JDocComment delegate;

        private JDocCommentWrapper(JStaticImports staticImports, JDefinedClass definedClass, JDocComment delegate) {
            super(null);
            this.staticImports = staticImports;
            this.definedClass = definedClass;
            this.delegate = delegate;
        }

        public JStaticImports getStaticImports() {
            return this.staticImports;
        }

        public JDefinedClass getDefinedClass() {
            return this.definedClass;
        }

        public JDocComment getDelegate() {
            if (this.delegate == null) {
                this.delegate = new JDocComment(this.definedClass.owner());
            }
            return this.delegate;
        }

        public void generate(JFormatter f) {
            this.staticImports.generate(f);
            if (this.delegate != null) {
                this.delegate.generate(f);
            }
        }

        public boolean add(Object o) {
            return this.getDelegate().add(o);
        }

        public void trimToSize() {
            this.getDelegate().trimToSize();
        }

        public void ensureCapacity(int minCapacity) {
            this.getDelegate().ensureCapacity(minCapacity);
        }

        public int size() {
            return this.getDelegate().size();
        }

        public boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        public boolean contains(Object elem) {
            return this.getDelegate().contains(elem);
        }

        public int indexOf(Object elem) {
            return this.getDelegate().indexOf(elem);
        }

        public int lastIndexOf(Object elem) {
            return this.getDelegate().lastIndexOf(elem);
        }

        public Object[] toArray() {
            return this.getDelegate().toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.getDelegate().toArray((Object[])a);
        }

        public Object get(int index) {
            return this.getDelegate().get(index);
        }

        public Object set(int index, Object element) {
            return this.getDelegate().set(index, element);
        }

        public void add(int index, Object element) {
            this.getDelegate().add(index, element);
        }

        public Object remove(int index) {
            return this.getDelegate().remove(index);
        }

        public boolean remove(Object o) {
            return this.getDelegate().remove(o);
        }

        public void clear() {
            this.getDelegate().clear();
        }

        public boolean addAll(Collection<? extends Object> c) {
            return this.getDelegate().addAll(c);
        }

        public boolean addAll(int index, Collection<? extends Object> c) {
            return this.getDelegate().addAll(index, c);
        }

        public Iterator<Object> iterator() {
            return this.getDelegate().iterator();
        }

        public ListIterator<Object> listIterator() {
            return this.getDelegate().listIterator();
        }

        public ListIterator<Object> listIterator(int index) {
            return this.getDelegate().listIterator(index);
        }

        public List<Object> subList(int fromIndex, int toIndex) {
            return this.getDelegate().subList(fromIndex, toIndex);
        }

        public boolean equals(Object o) {
            return this.getDelegate().equals(o);
        }

        public int hashCode() {
            return this.getDelegate().hashCode();
        }

        public boolean containsAll(Collection<?> c) {
            return this.getDelegate().containsAll(c);
        }

        public boolean removeAll(Collection<?> c) {
            return this.getDelegate().removeAll(c);
        }

        public boolean retainAll(Collection<?> c) {
            return this.getDelegate().retainAll(c);
        }

        public String toString() {
            return this.getDelegate().toString();
        }

        public JDocComment append(Object o) {
            return this.getDelegate().append(o);
        }

        public JCommentPart addParam(String param) {
            return this.getDelegate().addParam(param);
        }

        public JCommentPart addParam(JVar param) {
            return this.getDelegate().addParam(param);
        }

        public JCommentPart addThrows(Class exception) {
            return this.getDelegate().addThrows(exception);
        }

        public JCommentPart addThrows(JClass exception) {
            return this.getDelegate().addThrows(exception);
        }

        public JCommentPart addReturn() {
            return this.getDelegate().addReturn();
        }

        public JCommentPart addDeprecated() {
            return this.getDelegate().addDeprecated();
        }

        public Map<String, String> addXdoclet(String name) {
            return this.getDelegate().addXdoclet(name);
        }

        public Map<String, String> addXdoclet(String name, Map<String, String> attributes) {
            return this.getDelegate().addXdoclet(name, attributes);
        }

        public Map<String, String> addXdoclet(String name, String attribute, String value) {
            return this.getDelegate().addXdoclet(name, attribute, value);
        }
    }
}

