/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mule.api.MuleContext;
import org.mule.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.util.queue.AbstractQueueSession;
import org.mule.util.queue.LocalQueueTransactionContext;
import org.mule.util.queue.LocalTxQueueTransactionContext;
import org.mule.util.queue.QueueProvider;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.QueueTransactionContext;
import org.mule.util.queue.QueueXaResource;
import org.mule.util.queue.QueueXaResourceManager;
import org.mule.util.xa.AbstractResourceManager;
import org.mule.util.xa.AbstractTransactionContext;
import org.mule.util.xa.ResourceManagerException;
import org.mule.util.xa.XaTransactionRecoverer;

public class TransactionalQueueSession
extends AbstractQueueSession
implements QueueSession {
    private final QueueXaResource queueXaResource;
    private final AbstractResourceManager resourceManager;
    private final LocalTxQueueTransactionJournal localTxTransactionJournal;
    private final ReentrantReadWriteLock txContextReadWriteLock;
    private LocalQueueTransactionContext singleResourceTxContext;

    public TransactionalQueueSession(QueueProvider queueProvider, QueueXaResourceManager xaResourceManager, AbstractResourceManager resourceManager, XaTransactionRecoverer xaTransactionRecoverer, LocalTxQueueTransactionJournal localTxTransactionJournal, MuleContext muleContext) {
        super(queueProvider, muleContext);
        this.localTxTransactionJournal = localTxTransactionJournal;
        this.resourceManager = resourceManager;
        this.queueXaResource = new QueueXaResource(xaResourceManager, xaTransactionRecoverer, this.getQueueProvider());
        this.txContextReadWriteLock = new ReentrantReadWriteLock();
    }

    @Override
    protected QueueTransactionContext getTransactionalContext() {
        if (this.singleResourceTxContext != null) {
            return this.singleResourceTxContext;
        }
        return (QueueTransactionContext)this.queueXaResource.getTransactionContext();
    }

    @Override
    public void begin() throws ResourceManagerException {
        ReentrantReadWriteLock.WriteLock writeLock = this.txContextReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.getTransactionalContext() != null) {
                throw new IllegalStateException("Cannot start local transaction. A local transaction already in progress.");
            }
            this.singleResourceTxContext = new LocalTxQueueTransactionContext(this.localTxTransactionJournal, this.getQueueProvider(), this.txContextReadWriteLock.readLock());
            this.resourceManager.beginTransaction((AbstractTransactionContext)((Object)this.singleResourceTxContext));
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void commit() throws ResourceManagerException {
        ReentrantReadWriteLock.WriteLock writeLock = this.txContextReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.singleResourceTxContext == null) {
                throw new IllegalStateException("Cannot commit local transaction as no transaction was begun");
            }
            this.resourceManager.commitTransaction((AbstractTransactionContext)((Object)this.singleResourceTxContext));
            this.singleResourceTxContext = null;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void rollback() throws ResourceManagerException {
        ReentrantReadWriteLock.WriteLock writeLock = this.txContextReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.singleResourceTxContext == null) {
                throw new IllegalStateException("Cannot commit local transaction as no transaction was begun");
            }
            this.resourceManager.rollbackTransaction((AbstractTransactionContext)((Object)this.singleResourceTxContext));
            this.singleResourceTxContext = null;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        return this.queueXaResource.isSameRM(xares);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.queueXaResource.start(xid, flags);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.queueXaResource.end(xid, flags);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.queueXaResource.commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.queueXaResource.rollback(xid);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.queueXaResource.prepare(xid);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.queueXaResource.forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.queueXaResource.getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        return this.queueXaResource.setTransactionTimeout(timeout);
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        return this.queueXaResource.recover(i);
    }
}

