/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection.declaration.fluent;

import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.declaration.fluent.ConfigurationDescriptor;
import org.mule.extension.introspection.declaration.fluent.DeclarationDescriptor;
import org.mule.extension.introspection.declaration.fluent.Descriptor;
import org.mule.extension.introspection.declaration.fluent.HasCapabilities;
import org.mule.extension.introspection.declaration.fluent.HasParameters;
import org.mule.extension.introspection.declaration.fluent.OperationDescriptor;
import org.mule.extension.introspection.declaration.fluent.ParameterDeclaration;
import org.mule.extension.introspection.declaration.fluent.WithParameters;

public class ParameterDescriptor<T extends ParameterDescriptor>
implements Descriptor,
HasCapabilities<ParameterDescriptor<T>> {
    private final DeclarationDescriptor declaration;
    private final ParameterDeclaration parameter;
    private final HasParameters owner;

    ParameterDescriptor(HasParameters owner, ParameterDeclaration parameter, DeclarationDescriptor declaration) {
        this.declaration = declaration;
        this.owner = owner;
        this.parameter = parameter;
    }

    public T ofType(Class<?> type, Class<?> ... parametrizedTypes) {
        return this.ofType(DataType.of(type, parametrizedTypes));
    }

    public T ofType(DataType dataType) {
        this.parameter.setType(dataType);
        return (T)this;
    }

    public T describedAs(String description) {
        this.parameter.setDescription(description);
        return (T)this;
    }

    public T whichIsStatic() {
        this.parameter.setDynamic(false);
        return (T)this;
    }

    public T whichIsDynamic() {
        this.parameter.setDynamic(true);
        return (T)this;
    }

    public ConfigurationDescriptor withConfig(String name) {
        return this.getRootDeclaration().withConfig(name);
    }

    public OperationDescriptor withOperation(String name) {
        return this.getRootDeclaration().withOperation(name);
    }

    public WithParameters with() {
        return new WithParameters(this.owner, this.getRootDeclaration());
    }

    @Override
    public DeclarationDescriptor getRootDeclaration() {
        return this.declaration;
    }

    @Override
    public ParameterDescriptor<T> withCapability(Object capability) {
        this.parameter.addCapability(capability);
        return this;
    }

    public ParameterDeclaration getDeclaration() {
        return this.parameter;
    }
}

