/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.base.EvaluatorWrapper;
import org.drools.compiler.BoundIdentifiers;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.parser.JavaLexer;
import org.drools.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.rule.builder.dialect.java.parser.JavaParser;

public class JavaExprAnalyzer {
    public JavaAnalysisResult analyzeExpression(String expr, BoundIdentifiers availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream(expr);
        JavaLexer lexer = new JavaLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokenStream);
        parser.conditionalOrExpression();
        JavaAnalysisResult result = new JavaAnalysisResult();
        result.setIdentifiers(new HashSet<String>(parser.getIdentifiers()));
        return this.analyze(result, availableIdentifiers);
    }

    public JavaAnalysisResult analyzeBlock(String expr, BoundIdentifiers availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream("{" + expr + "}");
        JavaLexer lexer = new JavaLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokenStream);
        parser.block();
        JavaAnalysisResult result = new JavaAnalysisResult();
        result.setIdentifiers(new HashSet<String>(parser.getIdentifiers()));
        result.setLocalVariables(new HashMap<String, JavaLocalDeclarationDescr>());
        if (parser.getRootBlockDescr().getInScopeLocalVars() != null) {
            for (JavaLocalDeclarationDescr descr : parser.getRootBlockDescr().getInScopeLocalVars()) {
                for (JavaLocalDeclarationDescr.IdentifierDescr ident : descr.getIdentifiers()) {
                    result.addLocalVariable(ident.getIdentifier(), descr);
                }
            }
        }
        result.setBlockDescrs(parser.getRootBlockDescr());
        return this.analyze(result, availableIdentifiers);
    }

    private JavaAnalysisResult analyze(JavaAnalysisResult result, BoundIdentifiers availableIdentifiers) throws RecognitionException {
        Set<String> identifiers = result.getIdentifiers();
        HashSet<String> notBound = new HashSet<String>(identifiers);
        HashMap usedDecls = new HashMap();
        HashMap usedGlobals = new HashMap();
        HashMap<String, EvaluatorWrapper> usedOperators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getDeclrClasses().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedDecls.put(entry.getKey(), entry.getValue());
            notBound.remove(entry.getKey());
        }
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getGlobals().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedGlobals.put(entry.getKey(), entry.getValue());
            notBound.remove(entry.getKey());
        }
        for (Map.Entry<String, Class<?>> entry : availableIdentifiers.getOperators().entrySet()) {
            if (!identifiers.contains(entry.getKey())) continue;
            usedOperators.put(entry.getKey(), (EvaluatorWrapper)entry.getValue());
            notBound.remove(entry);
        }
        result.setBoundIdentifiers(new BoundIdentifiers(usedDecls, usedGlobals, usedOperators));
        result.setNotBoundedIdentifiers(notBound);
        return result;
    }
}

