/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ssl.api;

import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.registry.RegistrationException;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.transport.ssl.api.TlsContextFactory;

public class TlsContextFactoryBuilder {
    private static final String DEFAULT_TLS_CONTEXT_FACTORY_REGISTRY_KEY = "_muleDefaultTlsContextFactory";
    private final MuleContext muleContext;

    public TlsContextFactoryBuilder(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TlsContextFactory buildDefault() {
        MuleContext muleContext = this.muleContext;
        synchronized (muleContext) {
            TlsContextFactory tlsContextFactory = (TlsContextFactory)this.muleContext.getRegistry().get(DEFAULT_TLS_CONTEXT_FACTORY_REGISTRY_KEY);
            if (tlsContextFactory == null) {
                tlsContextFactory = new DefaultTlsContextFactory();
                try {
                    this.muleContext.getRegistry().registerObject(DEFAULT_TLS_CONTEXT_FACTORY_REGISTRY_KEY, (Object)tlsContextFactory);
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
            return tlsContextFactory;
        }
    }
}

