/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Field;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.integration.VariableResolverFactory;

public class DynamicFieldAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private Field field;
    private Class targetType;

    public DynamicFieldAccessor() {
    }

    public DynamicFieldAccessor(Field field) {
        this.field = field;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.field.get(ctx), elCtx, vars);
            }
            return this.field.get(ctx);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access field", e);
        }
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        try {
            if (this.nextNode != null) {
                return this.nextNode.setValue(this.field.get(ctx), elCtx, variableFactory, value);
            }
            this.field.set(ctx, DataConversion.convert(value, this.targetType));
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access field", e);
        }
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
        this.targetType = field.getType();
    }

    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    public Class getKnownEgressType() {
        return this.targetType;
    }
}

