/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.mule.transport.file.FileMuleMessageFactory;
import org.mule.util.IOUtils;

public class FileContentsMuleMessageFactory
extends FileMuleMessageFactory {
    @Override
    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{InputStream.class, File.class};
    }

    @Override
    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        InputStream inputStream = this.convertToInputStream(transportMessage);
        byte[] payload = IOUtils.toByteArray((InputStream)inputStream);
        inputStream.close();
        return payload;
    }

    private InputStream convertToInputStream(Object transportMessage) throws Exception {
        InputStream stream = null;
        if (transportMessage instanceof InputStream) {
            stream = (InputStream)transportMessage;
        } else if (transportMessage instanceof File) {
            stream = new FileInputStream((File)transportMessage);
        }
        return stream;
    }
}

