/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Fields
implements Iterable<Field> {
    private final boolean caseSensitive;
    private final Map<String, Field> fields;

    public Fields() {
        this(false);
    }

    public Fields(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.fields = new LinkedHashMap<String, Field>();
    }

    public Fields(Fields original, boolean immutable) {
        this.caseSensitive = original.caseSensitive;
        LinkedHashMap<String, Field> copy = new LinkedHashMap<String, Field>();
        copy.putAll(original.fields);
        this.fields = immutable ? Collections.unmodifiableMap(copy) : copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Fields that = (Fields)obj;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        for (Map.Entry<String, Field> entry : this.fields.entrySet()) {
            String name = entry.getKey();
            Field value = entry.getValue();
            if (value.equals(that.get(name), this.caseSensitive)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public Set<String> names() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Field field : this.fields.values()) {
            result.add(field.name());
        }
        return result;
    }

    private String normalizeName(String name) {
        return this.caseSensitive ? name : name.toLowerCase(Locale.ENGLISH);
    }

    public Field get(String name) {
        return this.fields.get(this.normalizeName(name));
    }

    public void put(String name, String value) {
        Field field = new Field(name, value);
        this.fields.put(this.normalizeName(name), field);
    }

    public void put(Field field) {
        if (field != null) {
            this.fields.put(this.normalizeName(field.name()), field);
        }
    }

    public void add(String name, String value) {
        String key = this.normalizeName(name);
        Field field = this.fields.get(key);
        if (field == null) {
            field = new Field(name, value);
            this.fields.put(key, field);
        } else {
            field = new Field(field.name(), field.values(), new String[]{value});
            this.fields.put(key, field);
        }
    }

    public Field remove(String name) {
        return this.fields.remove(this.normalizeName(name));
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int size() {
        return this.fields.size();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.values().iterator();
    }

    public String toString() {
        return this.fields.toString();
    }

    public static class Field {
        private final String name;
        private final String[] values;

        private Field(String name, String value) {
            this(name, new String[]{value}, new String[0]);
        }

        private Field(String name, String[] values, String ... moreValues) {
            this.name = name;
            this.values = new String[values.length + moreValues.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
            System.arraycopy(moreValues, 0, this.values, values.length, moreValues.length);
        }

        public boolean equals(Field that, boolean caseSensitive) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (caseSensitive) {
                return this.equals(that);
            }
            return this.name.equalsIgnoreCase(that.name) && Arrays.equals(this.values, that.values);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Field that = (Field)obj;
            return this.name.equals(that.name) && Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.values[0];
        }

        public Integer valueAsInt() {
            String value = this.value();
            return value == null ? null : Integer.valueOf(value);
        }

        public String[] values() {
            return this.values;
        }

        public boolean hasMultipleValues() {
            return this.values.length > 1;
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }
}

