/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cors.config;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.util.TemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractDefinitionParser
implements BeanDefinitionParser {
    private TemplateParser.PatternInfo patternInfo = TemplateParser.createMuleStyleParser().getStyle();

    protected boolean hasAttribute(Element element, String attributeName) {
        String value = element.getAttribute(attributeName);
        return value != null && !StringUtils.isBlank((String)value);
    }

    protected void setRef(BeanDefinitionBuilder builder, String propertyName, String ref) {
        if (!this.isMuleExpression(ref)) {
            builder.addPropertyValue(propertyName, (Object)new RuntimeBeanReference(ref));
        } else {
            builder.addPropertyValue(propertyName, (Object)ref);
        }
    }

    protected boolean isMuleExpression(String value) {
        return value.startsWith(this.patternInfo.getPrefix()) || value.endsWith(this.patternInfo.getSuffix());
    }

    protected ManagedList parseList(Element element, String childElementName, ParseDelegate parserDelegate) {
        ManagedList managedList = new ManagedList();
        List childDomElements = DomUtils.getChildElementsByTagName((Element)element, (String)childElementName);
        for (Element childDomElement : childDomElements) {
            if (this.hasAttribute(childDomElement, "value-ref")) {
                if (!this.isMuleExpression(childDomElement.getAttribute("value-ref"))) {
                    managedList.add((Object)new RuntimeBeanReference(childDomElement.getAttribute("value-ref")));
                    continue;
                }
                managedList.add((Object)childDomElement.getAttribute("value-ref"));
                continue;
            }
            managedList.add(parserDelegate.parse(childDomElement));
        }
        return managedList;
    }

    protected void parseListAndSetProperty(Element element, BeanDefinitionBuilder builder, String fieldName, String parentElementName, String childElementName, ParseDelegate parserDelegate) {
        Element domElement = DomUtils.getChildElementByTagName((Element)element, (String)parentElementName);
        if (domElement != null) {
            if (this.hasAttribute(domElement, "ref")) {
                this.setRef(builder, fieldName, domElement.getAttribute("ref"));
            } else {
                ManagedList managedList = this.parseList(domElement, childElementName, parserDelegate);
                builder.addPropertyValue(fieldName, (Object)managedList);
            }
        }
    }

    protected void parseConfigName(Element element) {
        if (this.hasAttribute(element, "name")) {
            element.setAttribute("name", AutoIdUtils.getUniqueName((Element)element, (String)"mule-bean"));
        }
    }

    protected void parseProperty(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        if (this.hasAttribute(element, attributeName)) {
            builder.addPropertyValue(propertyName, (Object)element.getAttribute(attributeName));
        }
    }

    protected void setNoRecurseOnDefinition(BeanDefinition definition) {
        definition.setAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE", (Object)Boolean.TRUE);
    }

    public static interface ParseDelegate<T> {
        public T parse(Element var1);
    }
}

