/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.mule.module.pgp.StreamTransformer;
import org.mule.module.pgp.config.PGPOutputMode;

public class EncryptStreamTransformer
implements StreamTransformer {
    private PGPPublicKey publicKey;
    private Provider provider;
    private final int algorithm;
    private OutputStream pgpOutputStream;
    private OutputStream compressedEncryptedOutputStream;
    private OutputStream encryptedOutputStream;
    private ByteArrayOutputStream outputStream;
    private PGPOutputMode pgpOutputMode;
    private OutputStream result;

    public EncryptStreamTransformer(PGPPublicKey publicKey, Provider provider, int algorithm, PGPOutputMode pgpOutputMode) throws IOException {
        Validate.notNull((Object)publicKey, (String)"The publicKey should not be null");
        this.publicKey = publicKey;
        this.provider = provider;
        this.algorithm = algorithm;
        this.pgpOutputMode = pgpOutputMode;
        this.outputStream = new ByteArrayOutputStream();
    }

    @Override
    public InputStream process(InputStream data) throws Exception {
        this.result = this.pgpOutputMode == PGPOutputMode.ARMOR ? new ArmoredOutputStream((OutputStream)this.outputStream) : this.outputStream;
        BcPGPDataEncryptorBuilder encryptorBuilder = new BcPGPDataEncryptorBuilder(this.algorithm);
        PGPEncryptedDataGenerator encrDataGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder, false);
        BcPublicKeyKeyEncryptionMethodGenerator methodGenerator = new BcPublicKeyKeyEncryptionMethodGenerator(this.publicKey);
        encrDataGen.addMethod((PGPKeyEncryptionMethodGenerator)methodGenerator);
        this.encryptedOutputStream = encrDataGen.open(this.result, new byte[65536]);
        PGPCompressedDataGenerator comprDataGen = new PGPCompressedDataGenerator(1);
        this.compressedEncryptedOutputStream = comprDataGen.open(this.encryptedOutputStream, new byte[65536]);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        this.pgpOutputStream = lData.open(this.compressedEncryptedOutputStream, 'b', "stream", new Date(), new byte[65536]);
        this.write(data);
        return new ByteArrayInputStream(this.outputStream.toByteArray());
    }

    private void write(InputStream toBeEncrypted) throws IOException {
        try {
            IOUtils.copy((InputStream)toBeEncrypted, (OutputStream)this.pgpOutputStream);
        }
        finally {
            this.pgpOutputStream.close();
            this.compressedEncryptedOutputStream.close();
            this.encryptedOutputStream.close();
            this.result.close();
            toBeEncrypted.close();
            this.outputStream.close();
        }
    }
}

