/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.config;

import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.config.spring.parsers.generic.OrphanDefinitionParser;
import org.mule.config.spring.parsers.specific.MessageProcessorDefinitionParser;
import org.mule.module.ws.config.spring.parsers.specific.WSProxyDefinitionParser;
import org.mule.module.ws.consumer.WSConsumer;
import org.mule.module.ws.consumer.WSConsumerConfig;
import org.mule.module.ws.security.WSSecurity;
import org.mule.module.ws.security.WssDecryptSecurityStrategy;
import org.mule.module.ws.security.WssEncryptSecurityStrategy;
import org.mule.module.ws.security.WssSignSecurityStrategy;
import org.mule.module.ws.security.WssTimestampSecurityStrategy;
import org.mule.module.ws.security.WssUsernameTokenSecurityStrategy;
import org.mule.module.ws.security.WssVerifySignatureSecurityStrategy;
import org.springframework.beans.factory.xml.BeanDefinitionParser;

public class WSNamespaceHandler
extends AbstractMuleNamespaceHandler {
    private static final String STRATEGY_PROPERTY = "strategy";

    public void init() {
        this.registerBeanDefinitionParser("proxy", (BeanDefinitionParser)new WSProxyDefinitionParser());
        this.registerBeanDefinitionParser("consumer-config", (BeanDefinitionParser)((OrphanDefinitionParser)new OrphanDefinitionParser(WSConsumerConfig.class, true).addReference("connectorConfig")));
        this.registerBeanDefinitionParser("consumer", (BeanDefinitionParser)new MessageProcessorDefinitionParser(WSConsumer.class));
        this.registerBeanDefinitionParser("security", (BeanDefinitionParser)new ChildDefinitionParser("security", WSSecurity.class));
        this.registerBeanDefinitionParser("wss-username-token", (BeanDefinitionParser)new ChildDefinitionParser(STRATEGY_PROPERTY, WssUsernameTokenSecurityStrategy.class));
        this.registerBeanDefinitionParser("wss-timestamp", (BeanDefinitionParser)new ChildDefinitionParser(STRATEGY_PROPERTY, WssTimestampSecurityStrategy.class));
        this.registerBeanDefinitionParser("wss-sign", (BeanDefinitionParser)new ChildDefinitionParser(STRATEGY_PROPERTY, WssSignSecurityStrategy.class));
        this.registerBeanDefinitionParser("wss-verify-signature", (BeanDefinitionParser)new ChildDefinitionParser(STRATEGY_PROPERTY, WssVerifySignatureSecurityStrategy.class));
        this.registerBeanDefinitionParser("wss-encrypt", (BeanDefinitionParser)new ChildDefinitionParser(STRATEGY_PROPERTY, WssEncryptSecurityStrategy.class));
        this.registerBeanDefinitionParser("wss-decrypt", (BeanDefinitionParser)new ChildDefinitionParser(STRATEGY_PROPERTY, WssDecryptSecurityStrategy.class));
    }
}

