/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.security;

import java.net.URI;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityFilter;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;

public class NotPermittedException
extends SecurityException {
    private static final long serialVersionUID = -6664384216189042673L;

    public NotPermittedException(Message message) {
        super(message, RequestContext.getEvent());
    }

    public NotPermittedException(Message message, Throwable cause, MessageProcessor failingMessageProcessor) {
        super(message, RequestContext.getEvent(), cause, failingMessageProcessor);
    }

    public NotPermittedException(Message message, MuleEvent event) {
        super(message, event);
    }

    public NotPermittedException(Message message, MuleEvent event, Throwable cause, MessageProcessor failingMessageProcessor) {
        super(message, event, cause, failingMessageProcessor);
    }

    public NotPermittedException(MuleEvent event, SecurityContext context, SecurityFilter filter) {
        super(NotPermittedException.constructMessage(context, event.getMessageSourceURI(), filter), event);
    }

    private static Message constructMessage(SecurityContext context, URI endpointURI, SecurityFilter filter) {
        Message m = context == null ? CoreMessages.authSetButNoContext(filter.getClass().getName()) : CoreMessages.authFailedForUser(context.getAuthentication().getPrincipal());
        m.setNextMessage(CoreMessages.authorizationDeniedOnEndpoint(endpointURI));
        return m;
    }
}

