/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.component.Component;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.component.AbstractComponentTestCase;
import org.mule.component.DefaultComponentLifecycleAdapter;
import org.mule.component.DefaultJavaComponent;
import org.mule.lifecycle.LifecycleTrackerComponent;
import org.mule.model.seda.SedaService;
import org.mule.object.PrototypeObjectFactory;
import org.mule.tck.testmodels.fruit.Orange;

public class DefaultJavaComponentTestCase
extends AbstractComponentTestCase {
    protected ObjectFactory createObjectFactory() throws InitialisationException {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(Orange.class);
        objectFactory.initialise();
        return objectFactory;
    }

    @Test
    public void testComponentCreation() throws Exception {
        ObjectFactory objectFactory = this.createObjectFactory();
        DefaultJavaComponent component = new DefaultJavaComponent(objectFactory);
        Assert.assertNotNull((Object)component.getObjectFactory());
        Assert.assertEquals((Object)objectFactory, (Object)component.getObjectFactory());
        Assert.assertEquals(Orange.class, (Object)component.getObjectFactory().getObjectClass());
        Assert.assertEquals(Orange.class, (Object)component.getObjectType());
    }

    @Test
    public void testLifecycle() throws Exception {
        DefaultJavaComponent component = new DefaultJavaComponent(this.createObjectFactory());
        component.setFlowConstruct((FlowConstruct)DefaultJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        Assert.assertNotSame((Object)component.borrowComponentLifecycleAdaptor(), (Object)component.borrowComponentLifecycleAdaptor());
        Object obj = component.getObjectFactory().getInstance(muleContext);
        Assert.assertNotNull((Object)obj);
        component.stop();
        component.start();
        Assert.assertNotSame((Object)((DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject, (Object)((DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor()).componentObject);
    }

    @Test
    public void testComponentDisposal() throws Exception {
        DefaultJavaComponent component = new DefaultJavaComponent(this.createObjectFactory());
        component.setFlowConstruct((FlowConstruct)DefaultJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        DefaultComponentLifecycleAdapter lifecycleAdapter = (DefaultComponentLifecycleAdapter)component.borrowComponentLifecycleAdaptor();
        component.returnComponentLifecycleAdaptor((LifecycleAdapter)lifecycleAdapter);
        component.stop();
        component.dispose();
        Assert.assertNull((Object)lifecycleAdapter.componentObject);
    }

    @Test
    public void testServicePropagatedLifecycle() throws InitialisationException {
        SedaService service = new SedaService(muleContext);
        service.setName("service");
        service.setModel(muleContext.getRegistry().lookupSystemModel());
        LifecycleTrackerComponent component = new LifecycleTrackerComponent();
        service.setComponent((Component)component);
        service.initialise();
        Assert.assertTrue((boolean)component.getTracker().contains("initialise"));
    }
}

