/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.expression.RequiredValueException;
import org.mule.expression.AbstractAttachmentsTestCase;
import org.mule.expression.MessageAttachmentExpressionEvaluator;

public class MessageAttachmentExpressionEvaluatorTestCase
extends AbstractAttachmentsTestCase {
    private MessageAttachmentExpressionEvaluator evaluator = new MessageAttachmentExpressionEvaluator();

    @Test
    public void requiredKeyWithExistingAttachmentShouldReturnAttachment() throws Exception {
        Object result = this.evaluator.evaluate("foo", this.message);
        this.assertAttachmentValueEquals("foovalue", result);
    }

    @Test
    public void requiredKeyWithExistingAttachmentViaExpressionManagerShouldReturnAttachment() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachment:foo]", this.message);
        this.assertAttachmentValueEquals("foovalue", result);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredKeyWithMissingAttachmentShouldFail() {
        this.evaluator.evaluate("nonexistent", this.message);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredKeyWithMissingAttachmentViaExpressionManagerShouldFail() {
        muleContext.getExpressionManager().evaluate("#[attachment:nonexistent]", this.message);
    }

    @Test
    public void optionalKeyWithExistingValueShouldReturnAttachment() throws Exception {
        Object result = this.evaluator.evaluate("foo?", this.message);
        this.assertAttachmentValueEquals("foovalue", result);
    }

    @Test
    public void optionalKeyWithExistingValueViaExpressionManagerShouldReturnAttachment() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachment:foo?]", this.message);
        this.assertAttachmentValueEquals("foovalue", result);
    }

    @Test
    public void optionalKeyWithMissingValueShouldReturnNull() {
        Object result = this.evaluator.evaluate("nonexistent?", this.message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void optionalKeyWithMissingValueViaExpressionManagerShouldReturnNull() {
        Object result = muleContext.getExpressionManager().evaluate("#[attachment:nonexistent?]", this.message);
        Assert.assertNull((Object)result);
    }
}

