/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.simple.CombineCollectionsTransformer;

public class CombineCollectionsTransformerTestCase
extends AbstractMuleContextTestCase {
    private CombineCollectionsTransformer merger;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.merger = new CombineCollectionsTransformer();
    }

    @Test
    public void testMuleMessageCollectionMerge() throws Exception {
        MuleEvent event = CombineCollectionsTransformerTestCase.getTestEvent("hello");
        DefaultMessageCollection collection = new DefaultMessageCollection(muleContext);
        collection.addMessage((MuleMessage)new DefaultMuleMessage(Arrays.asList("1", "2", "3"), muleContext));
        collection.addMessage((MuleMessage)new DefaultMuleMessage((Object)"4", muleContext));
        collection.addMessage((MuleMessage)new DefaultMuleMessage(Arrays.asList("5", "6", "7"), muleContext));
        event = new DefaultMuleEvent((MuleMessage)collection, event);
        MuleEvent response = this.merger.process(event);
        Assert.assertFalse((boolean)(response.getMessage() instanceof MuleMessageCollection));
        Assert.assertTrue((boolean)(response.getMessage().getPayload() instanceof List));
        Assert.assertEquals((long)7L, (long)((List)response.getMessage().getPayload()).size());
    }

    @Test
    public void testMuleMessageMerge() throws Exception {
        MuleEvent event = CombineCollectionsTransformerTestCase.getTestEvent("hello");
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(Arrays.asList("1", "2", "3"));
        payload.add("4");
        payload.add(Arrays.asList("5", "6", "7"));
        event.getMessage().setPayload(payload);
        MuleEvent response = this.merger.process(event);
        Assert.assertFalse((boolean)(response.getMessage() instanceof MuleMessageCollection));
        Assert.assertTrue((boolean)(response.getMessage().getPayload() instanceof List));
        Assert.assertEquals((long)7L, (long)((List)response.getMessage().getPayload()).size());
    }
}

