/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.routing.Foreach;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class ForeachTestCase
extends AbstractMuleContextTestCase {
    protected Foreach simpleForeach;
    protected Foreach nestedForeach;
    protected ArrayList<MuleEvent> processedEvents;
    private static String ERR_NUMBER_MESSAGES = "Not a correct number of messages processed";
    private static String ERR_PAYLOAD_TYPE = "Type error on processed payloads";
    private static String ERR_OUTPUT = "Messages processed incorrectly";

    @Before
    public void initialise() throws MuleException {
        this.processedEvents = new ArrayList();
        this.simpleForeach = this.createForeach(this.getSimpleMessageProcessors());
        this.nestedForeach = this.createForeach(this.getNestedMessageProcessors());
    }

    private List<MessageProcessor> getSimpleMessageProcessors() {
        ArrayList<MessageProcessor> lmp = new ArrayList<MessageProcessor>();
        lmp.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) {
                String payload = event.getMessage().getPayload().toString();
                event.getMessage().setPayload((Object)(payload + ":foo"));
                ForeachTestCase.this.processedEvents.add(event);
                return event;
            }
        });
        lmp.add(new TestMessageProcessor("zas"));
        return lmp;
    }

    private List<MessageProcessor> getNestedMessageProcessors() throws MuleException {
        ArrayList<MessageProcessor> lmp = new ArrayList<MessageProcessor>();
        Foreach internalForeach = new Foreach();
        internalForeach.setMessageProcessors(this.getSimpleMessageProcessors());
        lmp.add((MessageProcessor)internalForeach);
        return lmp;
    }

    private Foreach createForeach(List<MessageProcessor> mps) throws MuleException {
        Foreach foreachMp = new Foreach();
        foreachMp.setMessageProcessors(mps);
        foreachMp.setMuleContext(muleContext);
        foreachMp.initialise();
        return foreachMp;
    }

    @Test
    public void arrayListPayload() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("bar");
        arrayList.add("zip");
        this.simpleForeach.process(ForeachTestCase.getTestEvent(arrayList));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void arrayPayload() throws Exception {
        String[] array = new String[]{"bar", "zip"};
        this.simpleForeach.process(ForeachTestCase.getTestEvent(array));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void muleMessageCollectionPayload() throws Exception {
        DefaultMessageCollection msgCollection = new DefaultMessageCollection(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"bar", muleContext);
        msgCollection.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"zip", muleContext);
        msgCollection.addMessage((MuleMessage)msg);
        this.simpleForeach.process(ForeachTestCase.getTestEvent(msgCollection));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void iterablePayload() throws Exception {
        DummySimpleIterableClass iterable = new DummySimpleIterableClass();
        this.simpleForeach.process(ForeachTestCase.getTestEvent(iterable));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void iteratorPayload() throws Exception {
        DummySimpleIterableClass iterable = new DummySimpleIterableClass();
        this.simpleForeach.process(ForeachTestCase.getTestEvent(iterable.iterator()));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void nestedArrayListPayload() throws Exception {
        ArrayList payload = new ArrayList();
        ArrayList<String> elem1 = new ArrayList<String>();
        ArrayList<String> elem2 = new ArrayList<String>();
        ArrayList<String> elem3 = new ArrayList<String>();
        elem1.add("a1");
        elem1.add("a2");
        elem1.add("a3");
        elem2.add("b1");
        elem2.add("b2");
        elem3.add("c1");
        payload.add(elem1);
        payload.add(elem2);
        payload.add(elem3);
        this.nestedForeach.process(ForeachTestCase.getTestEvent(payload));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedArrayPayload() throws Exception {
        String[][] payload = new String[3][2];
        payload[0][0] = "a1";
        payload[0][1] = "a2";
        payload[1][0] = "a3";
        payload[1][1] = "b1";
        payload[2][0] = "b2";
        payload[2][1] = "c1";
        this.nestedForeach.process(ForeachTestCase.getTestEvent(payload));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedMuleMessageCollectionPayload() throws Exception {
        DefaultMessageCollection parentCollection = new DefaultMessageCollection(muleContext);
        DefaultMessageCollection childCollection1 = new DefaultMessageCollection(muleContext);
        DefaultMessageCollection childCollection2 = new DefaultMessageCollection(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"a1", muleContext);
        childCollection1.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"a2", muleContext);
        childCollection1.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"a3", muleContext);
        childCollection1.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"b1", muleContext);
        childCollection2.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"b2", muleContext);
        childCollection2.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"c1", muleContext);
        childCollection2.addMessage((MuleMessage)msg);
        parentCollection.addMessage((MuleMessage)childCollection1);
        parentCollection.addMessage((MuleMessage)childCollection2);
        this.nestedForeach.process(ForeachTestCase.getTestEvent(parentCollection));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedIterablePayload() throws Exception {
        DummyNestedIterableClass iterable = new DummyNestedIterableClass();
        this.nestedForeach.process(ForeachTestCase.getTestEvent(iterable));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void nestedIteratorPayload() throws Exception {
        DummyNestedIterableClass iterable = new DummyNestedIterableClass();
        this.nestedForeach.process(ForeachTestCase.getTestEvent(iterable.iterator()));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void addProcessorPathElementsBeforeInit() throws MuleException {
        Foreach foreachMp = new Foreach();
        foreachMp.setMuleContext(muleContext);
        List<MessageProcessor> processors = this.getSimpleMessageProcessors();
        foreachMp.setMessageProcessors(processors);
        MessageProcessorPathElement mpPathElement = (MessageProcessorPathElement)Mockito.mock(MessageProcessorPathElement.class);
        foreachMp.addMessageProcessorPathElements(mpPathElement);
        this.assertAddedPathElements(processors, mpPathElement);
    }

    @Test
    public void addProcessorPathElementsAfterInit() throws MuleException {
        Foreach foreachMp = new Foreach();
        foreachMp.setMuleContext(muleContext);
        List<MessageProcessor> processors = this.getSimpleMessageProcessors();
        foreachMp.setMessageProcessors(processors);
        foreachMp.initialise();
        MessageProcessorPathElement mpPathElement = (MessageProcessorPathElement)Mockito.mock(MessageProcessorPathElement.class);
        foreachMp.addMessageProcessorPathElements(mpPathElement);
        List<MessageProcessor> originalMessageProcessors = processors.subList(1, 3);
        this.assertAddedPathElements(originalMessageProcessors, mpPathElement);
    }

    @Test
    public void batchSize() throws Exception {
        Foreach foreachMp = new Foreach();
        foreachMp.setMuleContext(muleContext);
        List<MessageProcessor> processors = this.getSimpleMessageProcessors();
        foreachMp.setMessageProcessors(processors);
        foreachMp.setBatchSize(2);
        foreachMp.initialise();
        foreachMp.process(ForeachTestCase.getTestEvent(Arrays.asList(1, 2, 3)));
        Assert.assertThat(this.processedEvents, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)this.processedEvents.get(0).getMessageAsString(), (Matcher)Is.is((Object)"[1, 2]:foo:zas"));
        Assert.assertThat((Object)this.processedEvents.get(1).getMessageAsString(), (Matcher)Is.is((Object)"[3]:foo:zas"));
    }

    @Test
    public void batchSizeWithCollectionAttributes() throws Exception {
        Foreach foreachMp = new Foreach();
        foreachMp.setMuleContext(muleContext);
        List<MessageProcessor> processors = this.getSimpleMessageProcessors();
        foreachMp.setMessageProcessors(processors);
        foreachMp.setBatchSize(2);
        foreachMp.setCollectionExpression("flowVars.collection");
        foreachMp.initialise();
        MuleEvent event = ForeachTestCase.getTestEvent(null);
        event.setFlowVariable("collection", Arrays.asList(1, 2, 3));
        foreachMp.process(event);
        Assert.assertThat(this.processedEvents, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)this.processedEvents.get(0).getMessageAsString(), (Matcher)Is.is((Object)"[1, 2]:foo:zas"));
        Assert.assertThat((Object)this.processedEvents.get(1).getMessageAsString(), (Matcher)Is.is((Object)"[3]:foo:zas"));
    }

    protected void assertAddedPathElements(List<MessageProcessor> processors, MessageProcessorPathElement mpPathElement) {
        ((MessageProcessorPathElement)Mockito.verify((Object)mpPathElement, (VerificationMode)Mockito.times((int)processors.size()))).addChild((MessageProcessor)Matchers.any(MessageProcessor.class));
        ((MessageProcessorPathElement)Mockito.verify((Object)mpPathElement)).addChild(processors.get(0));
        ((MessageProcessorPathElement)Mockito.verify((Object)mpPathElement)).addChild(processors.get(1));
    }

    private void assertSimpleProcessedMessages() {
        Assert.assertEquals((String)ERR_NUMBER_MESSAGES, (long)2L, (long)this.processedEvents.size());
        Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(0).getMessage().getPayload() instanceof String));
        Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(1).getMessage().getPayload() instanceof String));
        Assert.assertEquals((String)ERR_OUTPUT, (Object)"bar:foo:zas", (Object)this.processedEvents.get(0).getMessage().getPayload());
        Assert.assertEquals((String)ERR_OUTPUT, (Object)"zip:foo:zas", (Object)this.processedEvents.get(1).getMessage().getPayload());
    }

    private void assertNestedProcessedMessages() {
        int i;
        String[] expectedOutputs = new String[]{"a1:foo:zas", "a2:foo:zas", "a3:foo:zas", "b1:foo:zas", "b2:foo:zas", "c1:foo:zas"};
        Assert.assertEquals((String)ERR_NUMBER_MESSAGES, (long)6L, (long)this.processedEvents.size());
        for (i = 0; i < this.processedEvents.size(); ++i) {
            Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(i).getMessage().getPayload() instanceof String));
        }
        for (i = 0; i < this.processedEvents.size(); ++i) {
            Assert.assertEquals((String)ERR_OUTPUT, (Object)expectedOutputs[i], (Object)this.processedEvents.get(i).getMessage().getPayload());
        }
    }

    private class DummyNestedIterableClass
    implements Iterable<DummySimpleIterableClass> {
        private List<DummySimpleIterableClass> iterables = new ArrayList<DummySimpleIterableClass>();

        public DummyNestedIterableClass() {
            DummySimpleIterableClass dsi1 = new DummySimpleIterableClass();
            dsi1.strings = new ArrayList<String>();
            dsi1.strings.add("a1");
            dsi1.strings.add("a2");
            DummySimpleIterableClass dsi2 = new DummySimpleIterableClass();
            dsi2.strings = new ArrayList<String>();
            dsi2.strings.add("a3");
            dsi2.strings.add("b1");
            dsi2.strings.add("b2");
            dsi2.strings.add("c1");
            this.iterables.add(dsi1);
            this.iterables.add(dsi2);
        }

        @Override
        public Iterator<DummySimpleIterableClass> iterator() {
            return this.iterables.iterator();
        }
    }

    public class DummySimpleIterableClass
    implements Iterable<String> {
        public List<String> strings = new ArrayList<String>();

        public DummySimpleIterableClass() {
            this.strings.add("bar");
            this.strings.add("zip");
        }

        @Override
        public Iterator<String> iterator() {
            return this.strings.iterator();
        }
    }
}

