/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.TimedSocket;

public class TimedSocketTestCase
extends AbstractMuleTestCase {
    private static final String REACHABLE_HOSTNAME = "127.0.0.1";
    private static final int REACHABLE_PORT = 3333;
    private static final String UNREACHABLE_HOSTNAME = "4.7.1.1";
    private static final int UNREACHABLE_PORT = 4711;
    private static final int TEST_TIMEOUT = 1000;
    private static final int TEST_TIMEOUT_DELTA = 300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testWorkingConnection() throws Exception {
        Socket client = null;
        ServerSocket server = null;
        try {
            server = new ServerSocket(3333);
            Assert.assertNotNull((Object)server);
            client = TimedSocket.createSocket((String)REACHABLE_HOSTNAME, (int)3333, (int)1000);
            Assert.assertNotNull((Object)client);
            return;
        }
        catch (InterruptedIOException iioe) {
            Assert.fail((String)"Server timed out");
            return;
        }
        catch (SocketException se) {
            Assert.fail((String)"Client/Server socket exception");
            return;
        }
        catch (IOException ioe) {
            Assert.fail((String)("Client/Server network I/O error - " + ioe));
            return;
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception ignore) {
                Assert.fail((String)"Error closing client connection");
            }
            finally {
                try {
                    if (server != null) {
                        server.close();
                    }
                }
                catch (Exception ignore) {
                    Assert.fail((String)"Error closing server connection");
                }
            }
        }
    }

    @Test
    public void testConnectionTimeoutInterruptionOnReachableHostnameAndUnreachablePort() throws Exception {
        Socket client = null;
        try {
            client = TimedSocket.createSocket((String)REACHABLE_HOSTNAME, (int)4711, (int)1000);
            Assert.fail((String)"Socket exception is expected");
        }
        catch (InterruptedIOException iioe) {
            Assert.assertNull((Object)client);
        }
        catch (MalformedURLException mue) {
            Assert.fail((String)"Invalid URL");
        }
        catch (SocketException se) {
            Assert.assertNull((Object)client);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Network I/O error - " + ioe));
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception ignore) {
                Assert.fail((String)"Error closing connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionTimeoutInterruptionOnUnreachableHostnameAndPost() throws Exception {
        Socket client = null;
        long startTime = 0L;
        long stopTime = 0L;
        try {
            startTime = System.currentTimeMillis();
            client = TimedSocket.createSocket((String)UNREACHABLE_HOSTNAME, (int)4711, (int)1000);
            Assert.fail((String)"Timeout is expected");
        }
        catch (InterruptedIOException iioe) {
            stopTime = System.currentTimeMillis();
            Assert.assertTrue((String)("Remote host timeout was longer than expected. Expected: 1000, but was" + stopTime), (stopTime - startTime > 700L ? 1 : 0) != 0);
        }
        catch (MalformedURLException mue) {
            Assert.fail((String)("Invalid URL: " + mue));
        }
        catch (SocketException se) {
            Assert.fail((String)("Socket exception: " + se));
        }
        catch (IOException ioe) {
            Assert.fail((String)("Network I/O error: " + ioe));
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception ignore) {
                Assert.fail((String)("Error closing connection: " + ignore));
            }
        }
    }
}

