/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.jndi;

import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.jms.jndi.AbstractJndiNameResolver;

public class SimpleJndiNameResolver
extends AbstractJndiNameResolver {
    private Context jndiContext;

    @Override
    public synchronized Object lookup(String name) throws NamingException {
        try {
            return this.doLookUp(name);
        }
        catch (CommunicationException e) {
            this.jndiContext = this.createInitialContext();
            return this.doLookUp(name);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.jndiContext == null) {
            try {
                this.jndiContext = this.createInitialContext();
            }
            catch (NamingException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.jndiContext != null) {
            try {
                this.jndiContext.close();
            }
            catch (NamingException e) {
                this.logger.error((Object)"Jms connector failed to dispose properly: ", (Throwable)e);
            }
            finally {
                this.jndiContext = null;
            }
        }
    }

    private Object doLookUp(String name) throws NamingException {
        return this.jndiContext.lookup(name);
    }
}

